/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.shaded.io.opentelemetry.sdk.trace.samplers;

import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.rocketmq.shaded.io.opentelemetry.api.common.Attributes;
import org.apache.rocketmq.shaded.io.opentelemetry.api.trace.SpanKind;
import org.apache.rocketmq.shaded.io.opentelemetry.context.Context;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.trace.data.LinkData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.trace.samplers.AlwaysOffSampler;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.trace.samplers.AlwaysOnSampler;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.trace.samplers.ParentBasedSamplerBuilder;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.trace.samplers.SamplingResult;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.trace.samplers.TraceIdRatioBasedSampler;

@ThreadSafe
public interface Sampler {
    public static Sampler alwaysOn() {
        return AlwaysOnSampler.INSTANCE;
    }

    public static Sampler alwaysOff() {
        return AlwaysOffSampler.INSTANCE;
    }

    public static Sampler parentBased(Sampler root) {
        return Sampler.parentBasedBuilder(root).build();
    }

    public static ParentBasedSamplerBuilder parentBasedBuilder(Sampler root) {
        return new ParentBasedSamplerBuilder(root);
    }

    public static Sampler traceIdRatioBased(double ratio) {
        return TraceIdRatioBasedSampler.create(ratio);
    }

    public SamplingResult shouldSample(Context var1, String var2, String var3, SpanKind var4, Attributes var5, List<LinkData> var6);

    public String getDescription();
}

