/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.xml.security.test;

import java.util.Collection;

import org.hamcrest.Matcher;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.RunResult;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.greaterThanOrEqualTo;
import static org.hamcrest.Matchers.hasSize;
import static org.junit.jupiter.api.Assertions.assertAll;

/**
 * @author David Matejcek
 */
public final class JmhUtils {

    private JmhUtils() {
        // hidden
    }

    public static void runAndVerify(Options opt, Matcher<Double> scoreMatcher, Matcher<Double> errorMatcher)
        throws RunnerException {
        Collection<RunResult> results = new Runner(opt).run();
        assertThat("results.size", results, hasSize(greaterThanOrEqualTo(1)));
        for (RunResult result : results) {
            Result<?> primaryResult = result.getAggregatedResult().getPrimaryResult();
            assertAll(
                () -> assertThat("Sample Time", primaryResult.getScore(), scoreMatcher),
                () -> assertThat("Sample Time Error", primaryResult.getScoreError(), errorMatcher)
            );
        }
    }


    public static  String getSystemOptArg(String name) {
        return "-D" + name + "=" + System.getProperty(name);
    }
}
