/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx.http;

import com.google.common.eventbus.EventBus;
import com.netflix.config.DynamicPropertyFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.foundation.vertx.http.InputStreamWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUploadStreamRecorder {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUploadStreamRecorder.class);
    private static final FileUploadStreamRecorder RECORDER = new FileUploadStreamRecorder();
    public static final String STREAM_RECORDER_MAX_SIZE = "servicecomb.uploads.file.streamRecorder.maxSize";
    public static final String STREAM_STACKTRACE_ENABLED = "servicecomb.uploads.file.streamRecorder.stackTraceEnabled";
    public static final String STREAM_CHECK_INTERVAL = "servicecomb.uploads.file.streamRecorder.checkInterval";
    public static final String STREAM_MAX_OPEN_TIME = "servicecomb.uploads.file.streamRecorder.streamMaxOpenTime";
    public static final int DEFAULT_STREAM_RECORDER_MAX_SIZE = 5000;
    public static final long DEFAULT_STREAM_CHECK_INTERVAL = 30000L;
    public static final long DEFAULT_STREAM_MAX_OPEN_TIME = 90000L;
    private final Map<InputStreamWrapper, StreamOperateEvent> streamWrapperRecorder = new ConcurrentHashMap<InputStreamWrapper, StreamOperateEvent>();
    private final EventBus eventBus;
    private final ScheduledExecutorService streamCheckExecutor;
    private final Object lock = new Object();

    private FileUploadStreamRecorder() {
        this.eventBus = EventManager.getEventBus();
        this.streamCheckExecutor = Executors.newScheduledThreadPool(1, t -> new Thread(t, "upload-file-stream-check"));
        this.startCheckRecordFileStream();
    }

    private void startCheckRecordFileStream() {
        this.streamCheckExecutor.scheduleWithFixedDelay(this::checkRecordFileStream, 30000L, this.getStreamCheckInterval(), TimeUnit.MILLISECONDS);
    }

    public static FileUploadStreamRecorder getInstance() {
        return RECORDER;
    }

    public void recordOpenStream(InputStreamWrapper wrapper) {
        this.checkAndRemoveOldestStream();
        this.streamWrapperRecorder.put(wrapper, new StreamOperateEvent(wrapper));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndRemoveOldestStream() {
        int maxSize = this.getStreamRecorderMaxSize();
        if (this.streamWrapperRecorder.size() < maxSize) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            StreamOperateEvent oldestEvent = this.getOldestOperateEvent(this.streamWrapperRecorder.values());
            LOGGER.warn("reached record maxSize [{}] of file stream, delete oldest stream, operate time [{}], stackTrace: ", new Object[]{maxSize, oldestEvent.getOpenStreamTimestamp(), oldestEvent.getInvokeStackTrace()});
            oldestEvent.setEventType(EventType.OVER_SIZE);
            this.eventBus.post((Object)oldestEvent);
            this.closeStreamWrapper(oldestEvent.getInputStreamWrapper());
        }
    }

    private StreamOperateEvent getOldestOperateEvent(Collection<StreamOperateEvent> values) {
        StreamOperateEvent oldestEvent = null;
        for (StreamOperateEvent event : values) {
            if (oldestEvent == null) {
                oldestEvent = event;
                continue;
            }
            if (oldestEvent.getOpenStreamTimestamp() <= event.getOpenStreamTimestamp()) continue;
            oldestEvent = event;
        }
        return oldestEvent;
    }

    public void clearRecorder(InputStreamWrapper inputStreamWrapper) {
        this.streamWrapperRecorder.remove(inputStreamWrapper);
    }

    private void checkRecordFileStream() {
        try {
            if (this.streamWrapperRecorder.isEmpty()) {
                return;
            }
            ArrayList<StreamOperateEvent> overdueStreamEvents = new ArrayList<StreamOperateEvent>();
            long currentMillis = System.currentTimeMillis();
            for (StreamOperateEvent event : this.streamWrapperRecorder.values()) {
                long streamOperateTime = event.getOpenStreamTimestamp();
                if (currentMillis - streamOperateTime < this.getStreamMaxOpenTime()) continue;
                overdueStreamEvents.add(event);
            }
            for (StreamOperateEvent overdueEvent : overdueStreamEvents) {
                overdueEvent.setEventType(EventType.TIMEOUT);
                this.eventBus.post((Object)overdueEvent);
                this.closeStreamWrapper(overdueEvent.getInputStreamWrapper());
                LOGGER.warn("closed timeout stream, operate time [{}], operate stackTrace: ", (Object)overdueEvent.getOpenStreamTimestamp(), (Object)overdueEvent.getInvokeStackTrace());
            }
        }
        catch (Exception e) {
            LOGGER.error("checkRecordFileStream failed, next interval will try again.", (Throwable)e);
        }
    }

    private void closeStreamWrapper(InputStreamWrapper wrapper) {
        try {
            wrapper.close();
        }
        catch (IOException e) {
            LOGGER.error("closed input stream failed!", (Throwable)e);
        }
    }

    private int getStreamRecorderMaxSize() {
        return DynamicPropertyFactory.getInstance().getIntProperty(STREAM_RECORDER_MAX_SIZE, 5000).get();
    }

    private static boolean getStreamStackTraceEnabled() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty(STREAM_STACKTRACE_ENABLED, false).get();
    }

    private long getStreamCheckInterval() {
        return DynamicPropertyFactory.getInstance().getLongProperty(STREAM_CHECK_INTERVAL, 30000L).get();
    }

    private long getStreamMaxOpenTime() {
        return DynamicPropertyFactory.getInstance().getLongProperty(STREAM_MAX_OPEN_TIME, 90000L).get();
    }

    public static class StreamOperateEvent {
        private final InputStreamWrapper inputStreamWrapper;
        private final long openStreamTimestamp;
        private Exception invokeStackTrace;
        private EventType eventType;

        public StreamOperateEvent(InputStreamWrapper inputStreamWrapper) {
            this.inputStreamWrapper = inputStreamWrapper;
            if (FileUploadStreamRecorder.getStreamStackTraceEnabled()) {
                this.invokeStackTrace = new Exception();
            }
            this.openStreamTimestamp = System.currentTimeMillis();
        }

        public InputStreamWrapper getInputStreamWrapper() {
            return this.inputStreamWrapper;
        }

        public Exception getInvokeStackTrace() {
            return this.invokeStackTrace;
        }

        public long getOpenStreamTimestamp() {
            return this.openStreamTimestamp;
        }

        public EventType getEventType() {
            return this.eventType;
        }

        public void setEventType(EventType eventType) {
            this.eventType = eventType;
        }
    }

    public static enum EventType {
        OVER_SIZE,
        TIMEOUT;

    }
}

