/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.filter.impl;

import jakarta.annotation.Nonnull;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.filter.FilterNode;
import org.apache.servicecomb.core.filter.InternalFilter;
import org.apache.servicecomb.swagger.invocation.Response;
import org.springframework.stereotype.Component;

@Component
public class TransportFilters
implements InternalFilter {
    public static final String NAME = "transport-filters";
    private final Map<String, FilterNode> chainByTransport = new HashMap<String, FilterNode>();

    @Override
    @Nonnull
    public String getName() {
        return NAME;
    }

    public Map<String, FilterNode> getChainByTransport() {
        return this.chainByTransport;
    }

    @Override
    public CompletableFuture<Response> onFilter(Invocation invocation, FilterNode nextNode) {
        FilterNode filterNode = this.chainByTransport.get(invocation.getTransport().getName());
        if (filterNode == null) {
            return nextNode.onFilter(invocation);
        }
        return filterNode.onFilter(invocation);
    }
}

