/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.invocation;

import jakarta.ws.rs.core.Response;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;

public interface InvocationTimeoutStrategy {
    public static final String CHAIN_ALREADY_TIMED_OUT = "x-scb-chain-timed-out";

    public String name();

    public void start(Invocation var1);

    default public void startRunInExecutor(Invocation invocation) {
        this.checkTimeout(invocation);
    }

    default public void startHandlers(Invocation invocation) {
        this.checkTimeout(invocation);
    }

    default public void startBusinessMethod(Invocation invocation) {
        this.checkTimeout(invocation);
    }

    default public void finishBusinessMethod(Invocation invocation) {
        this.checkTimeout(invocation);
    }

    default public void beforeSendRequest(Invocation invocation) {
        this.checkTimeout(invocation);
    }

    default public void checkTimeout(Invocation invocation) {
        long nanoInvocationTimeout = invocation.getOperationMeta().getConfig().getNanoInvocationTimeout();
        if (nanoInvocationTimeout <= 0L || this.alreadyTimeout(invocation)) {
            return;
        }
        long nanoTime = this.calculateElapsedNanoTime(invocation);
        if (nanoTime <= nanoInvocationTimeout) {
            return;
        }
        invocation.addLocalContext(CHAIN_ALREADY_TIMED_OUT, true);
        throw new InvocationException((Response.StatusType)Response.Status.REQUEST_TIMEOUT, "SCB.00000004", "Invocation Timeout.");
    }

    default public boolean alreadyTimeout(Invocation invocation) {
        return invocation.getLocalContext(CHAIN_ALREADY_TIMED_OUT) != null;
    }

    public long calculateElapsedNanoTime(Invocation var1);
}

