/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.oasv.diffvalidation.api;

import java.util.Objects;
import java.util.StringJoiner;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectPropertyLocation;

public class OasDiffViolation {
    private final OasObjectPropertyLocation leftLocation;
    private final OasObjectPropertyLocation rightLocation;
    private final String error;

    public static OasDiffViolation onlyLeft(OasObjectPropertyLocation location, String error) {
        return new OasDiffViolation(location, null, error);
    }

    public static OasDiffViolation onlyRight(OasObjectPropertyLocation location, String error) {
        return new OasDiffViolation(null, location, error);
    }

    public OasDiffViolation(OasObjectPropertyLocation leftLocation, OasObjectPropertyLocation rightLocation, String error) {
        this.leftLocation = leftLocation;
        this.rightLocation = rightLocation;
        this.error = error;
    }

    public OasObjectPropertyLocation getLeftLocation() {
        return this.leftLocation;
    }

    public OasObjectPropertyLocation getRightLocation() {
        return this.rightLocation;
    }

    public String getError() {
        return this.error;
    }

    public String toString() {
        return new StringJoiner(", ", OasDiffViolation.class.getSimpleName() + "[", "]").add("leftLocation=" + this.leftLocation).add("rightLocation=" + this.rightLocation).add("error='" + this.error + "'").toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OasDiffViolation that = (OasDiffViolation)o;
        return Objects.equals(this.leftLocation, that.leftLocation) && Objects.equals(this.rightLocation, that.rightLocation) && Objects.equals(this.error, that.error);
    }

    public int hashCode() {
        return Objects.hash(this.leftLocation, this.rightLocation, this.error);
    }
}

