/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.ShouldContainCharSequence;
import org.assertj.core.error.ShouldEndWith;
import org.assertj.core.error.ShouldHaveCause;
import org.assertj.core.error.ShouldHaveCauseExactlyInstance;
import org.assertj.core.error.ShouldHaveCauseInstance;
import org.assertj.core.error.ShouldHaveMessage;
import org.assertj.core.error.ShouldHaveMessageMatchingRegex;
import org.assertj.core.error.ShouldHaveNoCause;
import org.assertj.core.error.ShouldHaveNoSuppressedExceptions;
import org.assertj.core.error.ShouldHaveRootCauseExactlyInstance;
import org.assertj.core.error.ShouldHaveRootCauseInstance;
import org.assertj.core.error.ShouldHaveSuppressedException;
import org.assertj.core.error.ShouldStartWith;
import org.assertj.core.internal.CommonValidations;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.VisibleForTesting;

public class Throwables {
    private static final Throwables INSTANCE = new Throwables();
    @VisibleForTesting
    Failures failures = Failures.instance();

    public static Throwables instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Throwables() {
    }

    public void assertHasMessage(AssertionInfo info, Throwable actual, String expectedMessage) {
        Throwables.assertNotNull(info, actual);
        if (org.assertj.core.util.Objects.areEqual(actual.getMessage(), expectedMessage)) {
            return;
        }
        throw this.failures.failure(info, ShouldHaveMessage.shouldHaveMessage(actual, expectedMessage), actual.getMessage(), expectedMessage);
    }

    public void assertHasCause(AssertionInfo info, Throwable actual, Throwable expectedCause) {
        Throwables.assertNotNull(info, actual);
        Throwable actualCause = actual.getCause();
        if (actualCause == expectedCause) {
            return;
        }
        if (null == expectedCause) {
            this.assertHasNoCause(info, actual);
            return;
        }
        if (actualCause == null) {
            throw this.failures.failure(info, ShouldHaveCause.shouldHaveCause(actualCause, expectedCause));
        }
        if (!Throwables.compareThrowable(actualCause, expectedCause)) {
            throw this.failures.failure(info, ShouldHaveCause.shouldHaveCause(actualCause, expectedCause));
        }
    }

    public void assertHasNoCause(AssertionInfo info, Throwable actual) {
        Throwables.assertNotNull(info, actual);
        Throwable actualCause = actual.getCause();
        if (actualCause == null) {
            return;
        }
        throw this.failures.failure(info, ShouldHaveNoCause.shouldHaveNoCause(actual));
    }

    public void assertHasMessageStartingWith(AssertionInfo info, Throwable actual, String description) {
        Throwables.assertNotNull(info, actual);
        if (actual.getMessage() != null && actual.getMessage().startsWith(description)) {
            return;
        }
        throw this.failures.failure(info, ShouldStartWith.shouldStartWith(actual.getMessage(), description));
    }

    public void assertHasMessageContaining(AssertionInfo info, Throwable actual, String description) {
        Throwables.assertNotNull(info, actual);
        if (actual.getMessage() != null && actual.getMessage().contains(description)) {
            return;
        }
        throw this.failures.failure(info, ShouldContainCharSequence.shouldContain(actual.getMessage(), description));
    }

    public void assertHasStackTraceContaining(AssertionInfo info, Throwable actual, String description) {
        Throwables.assertNotNull(info, actual);
        String stackTrace = org.assertj.core.util.Throwables.getStackTrace(actual);
        if (stackTrace != null && stackTrace.contains(description)) {
            return;
        }
        throw this.failures.failure(info, ShouldContainCharSequence.shouldContain(stackTrace, description));
    }

    public void assertHasMessageMatching(AssertionInfo info, Throwable actual, String regex) {
        Preconditions.checkNotNull(regex, "regex must not be null");
        Throwables.assertNotNull(info, actual);
        if (actual.getMessage() != null && actual.getMessage().matches(regex)) {
            return;
        }
        throw this.failures.failure(info, ShouldHaveMessageMatchingRegex.shouldHaveMessageMatchingRegex(actual, regex));
    }

    public void assertHasMessageEndingWith(AssertionInfo info, Throwable actual, String description) {
        Throwables.assertNotNull(info, actual);
        if (actual.getMessage() != null && actual.getMessage().endsWith(description)) {
            return;
        }
        throw this.failures.failure(info, ShouldEndWith.shouldEndWith(actual.getMessage(), description));
    }

    public void assertHasCauseInstanceOf(AssertionInfo info, Throwable actual, Class<? extends Throwable> type) {
        Throwables.assertNotNull(info, actual);
        CommonValidations.checkTypeIsNotNull(type);
        if (type.isInstance(actual.getCause())) {
            return;
        }
        throw this.failures.failure(info, ShouldHaveCauseInstance.shouldHaveCauseInstance(actual, type));
    }

    public void assertHasCauseExactlyInstanceOf(AssertionInfo info, Throwable actual, Class<? extends Throwable> type) {
        Throwables.assertNotNull(info, actual);
        CommonValidations.checkTypeIsNotNull(type);
        Throwable cause = actual.getCause();
        if (cause != null && type.equals(cause.getClass())) {
            return;
        }
        throw this.failures.failure(info, ShouldHaveCauseExactlyInstance.shouldHaveCauseExactlyInstance(actual, type));
    }

    public void assertHasRootCauseInstanceOf(AssertionInfo info, Throwable actual, Class<? extends Throwable> type) {
        Throwables.assertNotNull(info, actual);
        CommonValidations.checkTypeIsNotNull(type);
        if (type.isInstance(org.assertj.core.util.Throwables.getRootCause(actual))) {
            return;
        }
        throw this.failures.failure(info, ShouldHaveRootCauseInstance.shouldHaveRootCauseInstance(actual, type));
    }

    public void assertHasRootCauseExactlyInstanceOf(AssertionInfo info, Throwable actual, Class<? extends Throwable> type) {
        Throwables.assertNotNull(info, actual);
        CommonValidations.checkTypeIsNotNull(type);
        Throwable rootCause = org.assertj.core.util.Throwables.getRootCause(actual);
        if (rootCause != null && type.equals(rootCause.getClass())) {
            return;
        }
        throw this.failures.failure(info, ShouldHaveRootCauseExactlyInstance.shouldHaveRootCauseExactlyInstance(actual, type));
    }

    public void assertHasNoSuppressedExceptions(AssertionInfo info, Throwable actual) {
        Throwables.assertNotNull(info, actual);
        Throwable[] suppressed = actual.getSuppressed();
        if (suppressed.length != 0) {
            throw this.failures.failure(info, ShouldHaveNoSuppressedExceptions.shouldHaveNoSuppressedExceptions(suppressed));
        }
    }

    public void assertHasSuppressedException(AssertionInfo info, Throwable actual, Throwable expectedSuppressedException) {
        Throwables.assertNotNull(info, actual);
        Preconditions.checkNotNull(expectedSuppressedException, "The expected suppressed exception should not be null");
        Throwable[] suppressed = actual.getSuppressed();
        for (int i = 0; i < suppressed.length; ++i) {
            if (!Throwables.compareThrowable(suppressed[i], expectedSuppressedException)) continue;
            return;
        }
        throw this.failures.failure(info, ShouldHaveSuppressedException.shouldHaveSuppressedException(actual, expectedSuppressedException));
    }

    private static void assertNotNull(AssertionInfo info, Throwable actual) {
        Objects.instance().assertNotNull(info, actual);
    }

    private static boolean compareThrowable(Throwable actual, Throwable expected) {
        return org.assertj.core.util.Objects.areEqual(actual.getMessage(), expected.getMessage()) && org.assertj.core.util.Objects.areEqual(actual.getClass(), expected.getClass());
    }
}

