/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.cli;

import io.airlift.airline.Arguments;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.StringJoiner;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.servicecomb.toolkit.cli.ValidationFailedException;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectPropertyLocation;
import org.apache.servicecomb.toolkit.oasv.compatibility.CompatibilityCheckParser;
import org.apache.servicecomb.toolkit.oasv.compatibility.factory.DefaultOasSpecDiffValidatorFactory;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.api.OasDiffValidationContext;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.api.OasDiffViolation;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.api.OasSpecDiffValidator;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.factory.OasSpecDiffValidatorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class CheckCompatibilityBase
implements Runnable {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Arguments(title="files", required=true, description="Two OpenAPI v3 spec yamls")
    private List<String> filePaths;

    @Override
    public void run() {
        if (this.filePaths.size() != 2) {
            this.LOGGER.error("Require 2 files");
            return;
        }
        OpenAPI oldOas = null;
        OpenAPI newOas = null;
        try {
            oldOas = this.loadOpenApi((String)this.filePaths.get(0));
            newOas = this.loadOpenApi((String)this.filePaths.get(1));
        }
        catch (Exception e) {
            this.LOGGER.error(e.getMessage());
            return;
        }
        OasSpecDiffValidator diffValidator = this.createOasSpecDiffValidator();
        List violations = diffValidator.validate(this.createContext(oldOas, newOas), oldOas, newOas);
        if (CollectionUtils.isNotEmpty((Collection)violations)) {
            for (OasDiffViolation violation : violations) {
                this.LOGGER.info("left  : {}\nright : {}\nerror : {}\n------", new Object[]{OasObjectPropertyLocation.toPathString((OasObjectPropertyLocation)violation.getLeftLocation()), OasObjectPropertyLocation.toPathString((OasObjectPropertyLocation)violation.getRightLocation()), violation.getError()});
            }
            throw new ValidationFailedException("check not passed");
        }
        this.LOGGER.info("Everything is good");
    }

    private OpenAPI loadOpenApi(String filePath) throws IOException {
        String yaml = this.loadFileContent(filePath);
        SwaggerParseResult oldParseResult = CompatibilityCheckParser.parseYaml((String)yaml);
        OpenAPI openAPI = oldParseResult.getOpenAPI();
        if (openAPI == null) {
            StringJoiner errors = new StringJoiner("\n", "Parse errors:", "");
            if (CollectionUtils.isNotEmpty((Collection)oldParseResult.getMessages())) {
                for (String message : oldParseResult.getMessages()) {
                    errors.add(message);
                }
            }
            throw new RuntimeException(errors.toString());
        }
        return openAPI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OasSpecDiffValidator createOasSpecDiffValidator() {
        try (AnnotationConfigApplicationContext ctx = new AnnotationConfigApplicationContext(new String[]{DefaultOasSpecDiffValidatorFactory.class.getPackage().getName()});){
            OasSpecDiffValidatorFactory diffValidatorFactory = (OasSpecDiffValidatorFactory)ctx.getBean(OasSpecDiffValidatorFactory.class);
            OasSpecDiffValidator oasSpecDiffValidator = diffValidatorFactory.create();
            return oasSpecDiffValidator;
        }
    }

    private String loadFileContent(String filePath) throws IOException {
        Path specPath = Paths.get(filePath, new String[0]);
        specPath.toAbsolutePath().toString();
        return FileUtils.readFileToString((File)specPath.toFile());
    }

    private OasDiffValidationContext createContext(OpenAPI leftOpenAPI, OpenAPI rightOpenAPI) {
        OasDiffValidationContext context = new OasDiffValidationContext(leftOpenAPI, rightOpenAPI);
        return context;
    }
}

