/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.catalog.UnsafeUriCharactersEncoder;

public final class URISupport {
    public static final String RAW_TOKEN_START = "RAW(";
    public static final String RAW_TOKEN_END = ")";
    private static final String CHARSET = "UTF-8";

    private URISupport() {
    }

    public static URI normalizeUri(String uri) throws URISyntaxException {
        return new URI(UnsafeUriCharactersEncoder.encode(uri, true));
    }

    public static Map<String, Object> extractProperties(Map<String, Object> properties, String optionPrefix) {
        LinkedHashMap<String, Object> rc = new LinkedHashMap<String, Object>(properties.size());
        Iterator<Map.Entry<String, Object>> it = properties.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            String name = entry.getKey();
            if (!name.startsWith(optionPrefix)) continue;
            Object value = properties.get(name);
            name = name.substring(optionPrefix.length());
            rc.put(name, value);
            it.remove();
        }
        return rc;
    }

    public static String stripQuery(String uri) {
        int idx = uri.indexOf(63);
        if (idx > -1) {
            uri = uri.substring(0, idx);
        }
        return uri;
    }

    public static Map<String, Object> parseParameters(URI uri) throws URISyntaxException {
        String query = uri.getQuery();
        if (query == null) {
            String schemeSpecificPart = uri.getSchemeSpecificPart();
            int idx = schemeSpecificPart.indexOf(63);
            if (idx < 0) {
                return new LinkedHashMap<String, Object>(0);
            }
            query = schemeSpecificPart.substring(idx + 1);
        } else {
            query = URISupport.stripPrefix(query, "?");
        }
        return URISupport.parseQuery(query);
    }

    public static String stripPrefix(String value, String prefix) {
        if (value != null && value.startsWith(prefix)) {
            return value.substring(prefix.length());
        }
        return value;
    }

    public static Map<String, Object> parseQuery(String uri) throws URISyntaxException {
        return URISupport.parseQuery(uri, false);
    }

    public static Map<String, Object> parseQuery(String uri, boolean useRaw) throws URISyntaxException {
        if (uri != null && uri.endsWith("&")) {
            throw new URISyntaxException(uri, "Invalid uri syntax: Trailing & marker found. Check the uri and remove the trailing & marker.");
        }
        if (URISupport.isEmpty(uri)) {
            return new LinkedHashMap<String, Object>(0);
        }
        try {
            LinkedHashMap<String, Object> rc = new LinkedHashMap<String, Object>();
            boolean isKey = true;
            boolean isValue = false;
            boolean isRaw = false;
            StringBuilder key = new StringBuilder();
            StringBuilder value = new StringBuilder();
            for (int i = 0; i < uri.length(); ++i) {
                char ch = uri.charAt(i);
                char next = i <= uri.length() - 2 ? uri.charAt(i + 1) : (char)'\u0000';
                isRaw = value.toString().startsWith(RAW_TOKEN_START);
                if (isRaw) {
                    boolean end;
                    if (isKey) {
                        key.append(ch);
                    } else if (isValue) {
                        value.append(ch);
                    }
                    boolean bl = end = ch == RAW_TOKEN_END.charAt(0) && (next == '&' || next == '\u0000');
                    if (!end) continue;
                    URISupport.addParameter(key.toString(), value.toString(), rc, useRaw || isRaw);
                    key.setLength(0);
                    value.setLength(0);
                    isKey = true;
                    isValue = false;
                    isRaw = false;
                    ++i;
                    continue;
                }
                if (isKey && ch == '=') {
                    isKey = false;
                    isValue = true;
                    isRaw = false;
                    continue;
                }
                if (ch == '&') {
                    URISupport.addParameter(key.toString(), value.toString(), rc, useRaw || isRaw);
                    key.setLength(0);
                    value.setLength(0);
                    isKey = true;
                    isValue = false;
                    isRaw = false;
                    continue;
                }
                if (isKey) {
                    key.append(ch);
                    continue;
                }
                if (!isValue) continue;
                value.append(ch);
            }
            if (key.length() > 0) {
                URISupport.addParameter(key.toString(), value.toString(), rc, useRaw || isRaw);
            }
            return rc;
        }
        catch (UnsupportedEncodingException e) {
            URISyntaxException se = new URISyntaxException(e.toString(), "Invalid encoding");
            se.initCause(e);
            throw se;
        }
    }

    private static void addParameter(String name, String value, Map<String, Object> map, boolean isRaw) throws UnsupportedEncodingException {
        name = URLDecoder.decode(name, CHARSET);
        if (!isRaw) {
            value = URLDecoder.decode(value.replaceAll("%", "%25"), CHARSET);
        }
        if (map.containsKey(name)) {
            ArrayList<String> list;
            Object existing = map.get(name);
            if (existing instanceof List) {
                list = (ArrayList<String>)existing;
            } else {
                String s;
                list = new ArrayList<String>();
                String string = s = existing != null ? existing.toString() : null;
                if (s != null) {
                    list.add(s);
                }
            }
            list.add(value);
            map.put(name, list);
        } else {
            map.put(name, value);
        }
    }

    public static String createQueryString(Map<String, String> options, String ampersand, boolean encode) throws URISyntaxException {
        try {
            if (options.size() > 0) {
                StringBuilder rc = new StringBuilder();
                boolean first = true;
                for (String o : options.keySet()) {
                    if (first) {
                        first = false;
                    } else {
                        rc.append(ampersand);
                    }
                    String key = o;
                    String value = options.get(key);
                    String s = value != null ? value.toString() : null;
                    URISupport.appendQueryStringParameter(key, s, rc, encode);
                }
                return rc.toString();
            }
            return "";
        }
        catch (UnsupportedEncodingException e) {
            URISyntaxException se = new URISyntaxException(e.toString(), "Invalid encoding");
            se.initCause(e);
            throw se;
        }
    }

    private static void appendQueryStringParameter(String key, String value, StringBuilder rc, boolean encode) throws UnsupportedEncodingException {
        if (encode) {
            rc.append(URLEncoder.encode(key, CHARSET));
        } else {
            rc.append(key);
        }
        if (value != null) {
            rc.append("=");
            if (value.startsWith(RAW_TOKEN_START) && value.endsWith(RAW_TOKEN_END)) {
                rc.append(value);
            } else if (encode) {
                rc.append(URLEncoder.encode(value, CHARSET));
            } else {
                rc.append(value);
            }
        }
    }

    public static boolean isEmpty(Object value) {
        return !URISupport.isNotEmpty(value);
    }

    public static boolean isNotEmpty(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof String) {
            String text = (String)value;
            return text.trim().length() > 0;
        }
        return true;
    }
}

