/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.transport;

import java.util.Objects;
import org.apache.sling.ide.util.PathUtil;

public class RepositoryPath {
    private final String path;

    public RepositoryPath(String path) {
        if (path == null || path.isEmpty() || !path.startsWith("/")) {
            throw new IllegalArgumentException("Invalid repository path: " + path);
        }
        this.path = path;
    }

    public boolean isParent(RepositoryPath maybeChild) {
        return PathUtil.isParent(this.asString(), maybeChild.asString());
    }

    public boolean isAncestor(RepositoryPath other) {
        return PathUtil.isAncestor(this.asString(), other.asString());
    }

    public boolean isDescendent(RepositoryPath other) {
        return PathUtil.isDescendent(this.asString(), other.asString());
    }

    public String getName() {
        return PathUtil.getName(this.path);
    }

    public RepositoryPath getParent() {
        return new RepositoryPath(PathUtil.getParent(this.asString()));
    }

    public RepositoryPath addChild(String name) {
        return new RepositoryPath(PathUtil.join(this.path, name));
    }

    public String asString() {
        return this.path;
    }

    public int hashCode() {
        return Objects.hash(this.path);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RepositoryPath other = (RepositoryPath)obj;
        return Objects.equals(this.path, other.path);
    }

    public String toString() {
        return "RepositoryPath [path=" + this.path + "]";
    }
}

