/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.ui.actions;

import java.io.IOException;
import org.apache.jackrabbit.vault.fs.io.DocViewFormat;
import org.apache.sling.ide.eclipse.ui.internal.SelectionUtils;
import org.apache.sling.ide.eclipse.ui.nav.model.JcrNode;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.handlers.HandlerUtil;

public class JcrNodeFormatHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.run(HandlerUtil.getCurrentSelection((ExecutionEvent)event));
        return null;
    }

    private void run(ISelection currentSelection) {
        JcrNode node = SelectionUtils.getFirst(currentSelection, JcrNode.class);
        if (node == null) {
            return;
        }
        final IFile resource = node.getFileForEditor();
        if (resource == null) {
            return;
        }
        final IPath resourcePath = resource.getFullPath();
        Job job = new Job(NLS.bind((String)"Formatting {0}", (Object)resourcePath)){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    DocViewFormat docViewFormat = new DocViewFormat();
                    if (docViewFormat.format(resource.getFullPath().toFile(), true)) {
                        resource.refreshLocal(0, monitor);
                    }
                }
                catch (IOException | CoreException e) {
                    return new Status(4, "org.apache.sling.ide.eclipse-core", NLS.bind((String)"Failed formatting {0}", (Object)resourcePath), e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(20);
        job.setRule((ISchedulingRule)resource);
        job.schedule();
    }
}

