/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.ui.views;

import java.util.Map;
import javax.jcr.PropertyType;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.sling.ide.eclipse.ui.nav.model.JcrNode;
import org.apache.sling.ide.eclipse.ui.nav.model.JcrProperty;
import org.apache.sling.ide.eclipse.ui.views.NewRow;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class JcrCellLabelProvider
extends CellLabelProvider {
    private final TableViewer viewer;
    private Color greyColor;
    private Color normalColor;

    public JcrCellLabelProvider(TableViewer viewer) {
        this.viewer = viewer;
        Display display = viewer.getControl().getDisplay();
        this.greyColor = display.getSystemColor(16);
        this.normalColor = viewer.getTable().getForeground();
    }

    public void update(ViewerCell cell) {
        int index = cell.getColumnIndex();
        if (!this.isNewRow(cell)) {
            if (this.canEdit(cell)) {
                cell.setForeground(this.normalColor);
            } else {
                cell.setForeground(this.greyColor);
            }
        }
        if (index == 0) {
            this.updateName(cell);
            return;
        }
        if (index == 1) {
            Object element = cell.getElement();
            if (element instanceof NewRow) {
                NewRow newRow = (NewRow)element;
                int propertyType = newRow.getType();
                String type = PropertyType.nameFromValue((int)propertyType);
                cell.setText(type);
            } else if (element instanceof IPropertyDescriptor) {
                Map.Entry me;
                String propertyName;
                IPropertyDescriptor pd = (IPropertyDescriptor)element;
                JcrNode jcrNode = (JcrNode)this.viewer.getInput();
                int propertyType = jcrNode.getPropertyType(propertyName = String.valueOf((me = (Map.Entry)pd.getId()).getKey()));
                if (propertyType <= -1 || propertyType == 0) {
                    cell.setText("");
                } else {
                    JcrProperty property = jcrNode.getProperty(propertyName);
                    Object type = PropertyType.nameFromValue((int)propertyType);
                    if (property != null && property.isMultiple()) {
                        type = (String)type + "[]";
                    }
                    cell.setText((String)type);
                }
            } else {
                cell.setText("");
            }
            return;
        }
        if (index == 2) {
            this.updateValue(cell);
            return;
        }
        Object element = cell.getElement();
        if (element instanceof NewRow) {
            NewRow cfr_ignored_0 = (NewRow)element;
            cell.setText("");
        } else if (element instanceof IPropertyDescriptor) {
            IPropertyDescriptor pd = (IPropertyDescriptor)element;
            JcrNode jcrNode = (JcrNode)this.viewer.getInput();
            Map.Entry me = (Map.Entry)pd.getId();
            PropertyDefinition prd = jcrNode.getPropertyDefinition(String.valueOf(me.getKey()));
            if (index == 3) {
                if (prd != null) {
                    cell.setText(String.valueOf(prd.isProtected()));
                } else {
                    cell.setText("false");
                }
            } else if (index == 4) {
                if (prd != null) {
                    cell.setText(String.valueOf(prd.isMandatory()));
                } else {
                    cell.setText("false");
                }
            } else if (index == 5) {
                if (prd != null) {
                    cell.setText(String.valueOf(prd.isMultiple()));
                } else {
                    cell.setText(String.valueOf(jcrNode.getProperty(String.valueOf(me.getKey())).isMultiple()));
                }
            } else if (index == 6) {
                if (prd != null) {
                    cell.setText(String.valueOf(prd.isAutoCreated()));
                } else {
                    cell.setText("false");
                }
            } else {
                cell.setText("n/a");
                return;
            }
        }
    }

    private boolean canEdit(ViewerCell cell) {
        Object element = cell.getElement();
        if (element instanceof NewRow) {
            return cell.getColumnIndex() <= 2;
        }
        if (element instanceof IPropertyDescriptor) {
            if (cell.getColumnIndex() > 2 && cell.getColumnIndex() != 5) {
                return false;
            }
            IPropertyDescriptor pd = (IPropertyDescriptor)element;
            JcrNode cfr_ignored_0 = (JcrNode)this.viewer.getInput();
            Map.Entry me = (Map.Entry)pd.getId();
            if (me.getKey().equals("jcr:primaryType")) {
                return cell.getColumnIndex() == 2;
            }
            return true;
        }
        return false;
    }

    private boolean isNewRow(ViewerCell cell) {
        return cell.getElement() instanceof NewRow;
    }

    private void updateValue(ViewerCell cell) {
        Object element = cell.getElement();
        if (element instanceof NewRow) {
            NewRow newRow = (NewRow)element;
            cell.setText(String.valueOf(newRow.getValue()));
        } else if (element instanceof IPropertyDescriptor) {
            IPropertyDescriptor pd = (IPropertyDescriptor)element;
            JcrNode cfr_ignored_0 = (JcrNode)this.viewer.getInput();
            Map.Entry me = (Map.Entry)pd.getId();
            String rawValue = String.valueOf(me.getValue());
            int index = rawValue.indexOf("}");
            if (index != -1) {
                cell.setText(rawValue.substring(index + 1));
            } else {
                cell.setText(rawValue);
            }
        } else {
            cell.setText(String.valueOf(element));
        }
    }

    private void updateName(ViewerCell cell) {
        Object element = cell.getElement();
        if (element instanceof NewRow) {
            NewRow newRow = (NewRow)element;
            cell.setText(String.valueOf(newRow.getName()));
        } else if (element instanceof IPropertyDescriptor) {
            IPropertyDescriptor pd = (IPropertyDescriptor)element;
            cell.setText(pd.getDisplayName());
        } else {
            cell.setText(String.valueOf(element));
        }
    }
}

