/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.bookkeeper;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class LocalStore {
    static final String ROOT_PATH = "/var/sling/distribution/journal/stores";
    private static final Logger LOG = LoggerFactory.getLogger(LocalStore.class);
    private final ResourceResolverFactory resolverFactory;
    private final String storeId;
    private final String rootPath;

    public LocalStore(ResourceResolverFactory resolverFactory, String storeType, String storeId) {
        this.resolverFactory = Objects.requireNonNull(resolverFactory);
        this.rootPath = String.format("%s/%s", ROOT_PATH, Objects.requireNonNull(storeType));
        this.storeId = Objects.requireNonNull(storeId);
        this.createParent();
    }

    public synchronized void store(String key, Object value) throws PersistenceException {
        try (ResourceResolver resolver = Objects.requireNonNull(this.getBookKeeperServiceResolver());){
            this.store(resolver, key, value);
            resolver.commit();
        }
        catch (LoginException e) {
            throw new RuntimeException("Failed to load data from the repository." + e.getMessage(), e);
        }
    }

    public synchronized void store(ResourceResolver serviceResolver, String key, Object value) throws PersistenceException {
        this.store(serviceResolver, Collections.singletonMap(key, value));
    }

    public synchronized void store(ResourceResolver serviceResolver, Map<String, Object> map) throws PersistenceException {
        Resource parent = this.getParent(serviceResolver);
        Resource store = parent.getChild(this.storeId);
        if (store != null) {
            ((ModifiableValueMap)store.adaptTo(ModifiableValueMap.class)).putAll(map);
        } else {
            serviceResolver.create(parent, this.storeId, map);
        }
        LOG.debug(String.format("Stored data %s for storeId %s", map.toString(), this.storeId));
    }

    public <T> T load(String key, Class<T> clazz) {
        return (T)this.load().get(key, clazz);
    }

    public <T> T load(String key, T defaultValue) {
        LOG.debug(String.format("Loading key %s for storeId %s with default value %s", key, this.storeId, defaultValue));
        return (T)this.load().get(key, defaultValue);
    }

    public ValueMap load() {
        ValueMapDecorator valueMapDecorator;
        block8: {
            LOG.debug(String.format("Loading data for storeId %s", this.storeId));
            ResourceResolver serviceResolver = Objects.requireNonNull(this.getBookKeeperServiceResolver());
            try {
                Resource parent = this.getParent(serviceResolver);
                Resource store = parent.getChild(this.storeId);
                Map properties = store != null ? this.filterJcrProperties(store.getValueMap()) : Collections.emptyMap();
                LOG.debug(String.format("Loaded data %s for storeId %s", properties.toString(), this.storeId));
                valueMapDecorator = new ValueMapDecorator(properties);
                if (serviceResolver == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (serviceResolver != null) {
                        try {
                            serviceResolver.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (LoginException e) {
                    throw new RuntimeException("Failed to load data from the repository." + e.getMessage(), e);
                }
            }
            serviceResolver.close();
        }
        return valueMapDecorator;
    }

    @Nonnull
    private Resource getParent(ResourceResolver resolver) {
        String msg = "Parent path " + this.rootPath + " should have been created on construction. Possibly the stores were reset";
        return Objects.requireNonNull(resolver.getResource(this.rootPath), msg);
    }

    private void createParent() {
        try (ResourceResolver resolver = this.getBookKeeperServiceResolver();){
            ResourceUtil.getOrCreateResource((ResourceResolver)resolver, (String)this.rootPath, (String)"sling:Folder", (String)"sling:Folder", (boolean)true);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create parent path " + this.rootPath + ". " + e.getMessage(), e);
        }
    }

    private Map<String, Object> filterJcrProperties(ValueMap map) {
        return map.entrySet().stream().filter(e -> !((String)e.getKey()).startsWith("jcr:")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private ResourceResolver getBookKeeperServiceResolver() throws LoginException {
        return this.resolverFactory.getServiceResourceResolver(Collections.singletonMap("sling.service.subservice", "bookkeeper"));
    }
}

