/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.bookkeeper;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.journal.BinaryStore;
import org.apache.sling.distribution.journal.bookkeeper.ContentPackageExtractor;
import org.apache.sling.distribution.journal.messages.PackageMessage;
import org.apache.sling.distribution.packaging.DistributionPackageBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PackageHandler {
    private static final Logger LOG = LoggerFactory.getLogger(PackageHandler.class);
    private final DistributionPackageBuilder packageBuilder;
    private final ContentPackageExtractor extractor;
    private final BinaryStore binaryStore;

    public PackageHandler(DistributionPackageBuilder packageBuilder, ContentPackageExtractor extractor, BinaryStore binaryStore) {
        this.packageBuilder = packageBuilder;
        this.extractor = extractor;
        this.binaryStore = binaryStore;
    }

    public void apply(ResourceResolver resolver, PackageMessage pkgMsg) throws DistributionException, PersistenceException {
        PackageMessage.ReqType type = pkgMsg.getReqType();
        switch (type) {
            case ADD: {
                this.installAddPackage(resolver, pkgMsg);
                break;
            }
            case DELETE: {
                this.installDeletePackage(resolver, pkgMsg);
                break;
            }
            case TEST: {
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unable to process messages with type: %s", type));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installAddPackage(ResourceResolver resolver, PackageMessage pkgMsg) throws DistributionException {
        LOG.debug("Importing paths {}", (Object)pkgMsg.getPaths());
        InputStream pkgStream = null;
        try {
            pkgStream = PackageHandler.stream(resolver, pkgMsg, this.binaryStore);
            this.packageBuilder.installPackage(resolver, pkgStream);
            this.extractor.handle(resolver, pkgMsg.getPaths());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(pkgStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)pkgStream);
    }

    @Nonnull
    public static InputStream stream(ResourceResolver resolver, PackageMessage pkgMsg, BinaryStore binaryStore) throws DistributionException {
        if (pkgMsg.getPkgBinary() != null) {
            return new ByteArrayInputStream(pkgMsg.getPkgBinary());
        }
        String pkgBinRef = pkgMsg.getPkgBinaryRef();
        try {
            return binaryStore.get(pkgBinRef);
        }
        catch (IOException io) {
            throw new DistributionException(io.getMessage(), (Throwable)io);
        }
    }

    private void installDeletePackage(ResourceResolver resolver, PackageMessage pkgMsg) throws PersistenceException {
        LOG.info("Deleting paths {}", (Object)pkgMsg.getPaths());
        for (String path : pkgMsg.getPaths()) {
            Resource resource = resolver.getResource(path);
            if (resource == null) continue;
            resolver.delete(resource);
        }
    }
}

