/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.queue.impl;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.sling.distribution.journal.queue.OffsetQueue;
import org.apache.sling.distribution.journal.queue.impl.OffsetQueueImplMBean;

@ParametersAreNonnullByDefault
public class OffsetQueueImpl<T>
implements OffsetQueue<T>,
OffsetQueueImplMBean {
    private final SortedMap<Long, T> entries;

    public OffsetQueueImpl() {
        this(new ConcurrentSkipListMap());
    }

    private OffsetQueueImpl(SortedMap<Long, T> entries) {
        this.entries = Objects.requireNonNull(entries);
    }

    @Override
    public void putItem(long offset, T item) {
        this.entries.put(offset, item);
    }

    @Override
    public void putItems(OffsetQueue<T> offsetQueue) {
        if (!(offsetQueue instanceof OffsetQueueImpl)) {
            throw new IllegalArgumentException(String.format("Unsupported offsetQueue type %s", offsetQueue));
        }
        this.entries.putAll(((OffsetQueueImpl)offsetQueue).entries);
    }

    @Override
    public T getItem(long offset) {
        return (T)this.entries.get(offset);
    }

    @Override
    public T getHeadItem() {
        try {
            long firstKey = this.entries.firstKey();
            return (T)this.entries.get(firstKey);
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    @Override
    @Nonnull
    public Iterable<T> getHeadItems(int skip, int limit) {
        int maxSize = limit == -1 ? Integer.MAX_VALUE : limit;
        return this.entries.values().stream().skip(skip).limit(maxSize).collect(Collectors.toList());
    }

    @Override
    public long getHeadOffset() {
        try {
            return this.entries.firstKey();
        }
        catch (NoSuchElementException ignore) {
            return -1L;
        }
    }

    @Override
    public long getTailOffset() {
        try {
            return this.entries.lastKey();
        }
        catch (NoSuchElementException ignore) {
            return -1L;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public int getSize() {
        return this.entries.size();
    }

    @Override
    @Nonnull
    public OffsetQueue<T> getMinOffsetQueue(long minOffset) {
        return new OffsetQueueImpl<T>(this.entries.tailMap(minOffset));
    }
}

