/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.bookkeeper;

import java.util.function.Consumer;
import org.apache.jackrabbit.vault.packaging.Packaging;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.distribution.ImportPostProcessor;
import org.apache.sling.distribution.ImportPreProcessor;
import org.apache.sling.distribution.InvalidationProcessor;
import org.apache.sling.distribution.journal.BinaryStore;
import org.apache.sling.distribution.journal.bookkeeper.BookKeeper;
import org.apache.sling.distribution.journal.bookkeeper.BookKeeperConfig;
import org.apache.sling.distribution.journal.bookkeeper.ContentPackageExtractor;
import org.apache.sling.distribution.journal.bookkeeper.PackageHandler;
import org.apache.sling.distribution.journal.bookkeeper.SubscriberMetrics;
import org.apache.sling.distribution.journal.messages.LogMessage;
import org.apache.sling.distribution.journal.messages.PackageStatusMessage;
import org.apache.sling.distribution.packaging.DistributionPackageBuilder;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.EventAdmin;

@Component(service={BookKeeperFactory.class})
public class BookKeeperFactory {
    @Reference
    private ResourceResolverFactory resolverFactory;
    @Reference
    private EventAdmin eventAdmin;
    @Reference
    Packaging packaging;
    @Reference
    BinaryStore binaryStore;
    @Reference
    ImportPreProcessor importPreProcessor;
    @Reference
    ImportPostProcessor importPostProcessor;
    @Reference
    InvalidationProcessor invalidationProcessor;

    public BookKeeper create(DistributionPackageBuilder packageBuilder, BookKeeperConfig config, Consumer<PackageStatusMessage> statusSender, Consumer<LogMessage> logSender, SubscriberMetrics subscriberMetrics) {
        ContentPackageExtractor extractor = new ContentPackageExtractor(this.packaging, config.getPackageHandling(), config.shouldExtractorOverwriteFolderPrimaryTypes());
        PackageHandler packageHandler = new PackageHandler(packageBuilder, extractor, this.binaryStore);
        return new BookKeeper(this.resolverFactory, subscriberMetrics, packageHandler, this.eventAdmin, statusSender, logSender, config, this.importPreProcessor, this.importPostProcessor, this.invalidationProcessor);
    }
}

