/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.bookkeeper;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.vault.fs.api.IdConflictPolicy;
import org.apache.jackrabbit.vault.fs.api.ProgressTrackerListener;
import org.apache.jackrabbit.vault.fs.io.ImportOptions;
import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.apache.jackrabbit.vault.packaging.JcrPackageManager;
import org.apache.jackrabbit.vault.packaging.PackageException;
import org.apache.jackrabbit.vault.packaging.Packaging;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.journal.bookkeeper.ErrorListener;
import org.apache.sling.distribution.journal.bookkeeper.PackageHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ContentPackageExtractor {
    private static final String PACKAGE_BASE_PATH = "/etc/packages/";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Packaging packageService;
    private final PackageHandling packageHandling;
    private final boolean overwritePrimaryTypesOfFolders;

    public ContentPackageExtractor(Packaging packageService, PackageHandling packageHandling, boolean overwritePrimaryTypesOfFolders) {
        this.packageService = packageService;
        this.packageHandling = packageHandling;
        this.overwritePrimaryTypesOfFolders = overwritePrimaryTypesOfFolders;
    }

    public void handle(ResourceResolver resourceResolver, List<String> paths) throws DistributionException {
        Objects.requireNonNull(resourceResolver, "Must provide resourceResolver");
        if (this.packageHandling == PackageHandling.Off) {
            return;
        }
        this.log.debug("Scanning imported nodes for packages to install.");
        for (String path : paths) {
            if (!this.isContentPackagePath(path)) continue;
            this.handlePath(resourceResolver, path);
        }
    }

    private void handlePath(ResourceResolver resourceResolver, String path) throws DistributionException {
        try {
            Resource resource = resourceResolver.getResource(path);
            if (resource != null) {
                Node node = (Node)resource.adaptTo(Node.class);
                if (this.isContentPackage(node)) {
                    this.installPackage(path, node);
                }
            } else {
                this.log.warn("Imported node {} does not exist. Skipping.", (Object)path);
            }
        }
        catch (Exception e) {
            throw new DistributionException(String.format("Error trying to extract package at path %s because of '%s'", path, e.getMessage()), (Throwable)e);
        }
    }

    private boolean isContentPackagePath(String path) {
        return path != null && path.startsWith(PACKAGE_BASE_PATH);
    }

    private boolean isContentPackage(Node node) throws RepositoryException {
        return node != null && node.isNodeType("{http://www.jcp.org/jcr/nt/1.0}file");
    }

    private void installPackage(String path, Node node) throws RepositoryException, PackageException, IOException {
        this.log.info("Content package received at {}. Starting import.\n", (Object)path);
        Session session = node.getSession();
        JcrPackageManager packMgr = this.packageService.getPackageManager(session);
        ErrorListener listener = new ErrorListener();
        try (JcrPackage pack = packMgr.open(node);){
            if (pack != null) {
                this.installPackage(pack, listener);
            }
        }
        catch (PackageException e) {
            this.failed(listener.getLastErrorMessage(), e);
        }
    }

    private void installPackage(JcrPackage pack, ErrorListener listener) throws RepositoryException, PackageException, IOException {
        ImportOptions opts = new ImportOptions();
        opts.setIdConflictPolicy(IdConflictPolicy.LEGACY);
        opts.setOverwritePrimaryTypesOfFolders(this.overwritePrimaryTypesOfFolders);
        opts.setListener((ProgressTrackerListener)listener);
        opts.setStrict(true);
        if (this.packageHandling == PackageHandling.Extract) {
            pack.extract(opts);
        } else {
            pack.install(opts);
        }
    }

    private void failed(@Nullable String errorMsg, PackageException e) throws PackageException {
        if (errorMsg != null) {
            throw new PackageException(errorMsg, (Throwable)e);
        }
        throw e;
    }
}

