/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.sling.feature.extension.apiregions.api.config;

/**
 * Constants used in this implementation
 */
abstract class InternalConstants {
    
    static final String KEY_TITLE = "title";

	static final String KEY_DESCRIPTION = "description";

	static final String KEY_DEPRECATED = "deprecated";

    static final String KEY_SINCE = "since";

    static final String KEY_ENFORCE_ON = "enforce-on";
	
	static final String KEY_PROPERTIES = "properties";

    static final String KEY_CONFIGURATIONS = "configurations";

    static final String KEY_FACTORIES = "factory-configurations";
    
    static final String KEY_CONFIGURATION_ADDITIONS = "configuration-additions";

    static final String KEY_FACTORY_ADDITIONS = "factory-configuration-additions";

    static final String KEY_FWK_PROPERTIES = "framework-properties";

    static final String KEY_INTERNAL_CONFIGURATIONS = "internal-configurations";

    static final String KEY_INTERNAL_FACTORIES = "internal-factory-configurations";
    
    static final String KEY_INTERNAL_FWK_PROPERTIES = "internal-framework-properties";
	
	static final String KEY_TYPE = "type";
	
	static final String KEY_CARDINALITY = "cardinality";
	
    static final String KEY_VARIABLE = "variable";
    
    static final String KEY_RANGE = "range";

    static final String KEY_MIN = "min";

    static final String KEY_MAX = "max";

    static final String KEY_INCLUDES = "includes";

    static final String KEY_EXCLUDES = "excludes";

    static final String KEY_OPTIONS = "options";
  
    static final String KEY_REGEX = "regex";

    static final String KEY_VALUE = "value";

    static final String KEY_REQUIRED = "required";

    static final String KEY_OPERATIONS = "operations";

    static final String KEY_INTERNAL_NAMES = "internal-names";

    static final String KEY_REGION = "region";

    static final String KEY_REGION_CACHE = "region-cache";

    static final String KEY_DEFAULT = "default";

    static final String KEY_MODE = "mode";

    static final String KEY_PLACEHOLDER_POLICY = "placeholder-policy";

    static final String KEY_PLACEHOLDER_REGEX = "placeholder-regex";

    static final String KEY_ALLOW_ADDITIONAL_PROPERTIES = "allow-additional-properties";

    static final String KEY_INTERNAL_PROPERTIES = "internal-property-names";
}
