/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.i18n.impl;

import java.util.Iterator;
import java.util.Set;
import org.apache.sling.api.resource.AbstractResourceVisitor;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.i18n.impl.PotentialLanguageRootCheck;

class LocatorPathsVisitor
extends AbstractResourceVisitor {
    private final PotentialLanguageRootCheck check;
    private final Set<String> paths;
    private int traverseDepth;

    public LocatorPathsVisitor(PotentialLanguageRootCheck check, Set<String> paths) {
        this.check = check;
        this.paths = paths;
    }

    public void accept(Resource res, int traverseDepth) {
        this.traverseDepth = traverseDepth;
        super.accept(res);
    }

    protected void traverseChildren(Iterator<Resource> children) {
        if (this.traverseDepth > 0) {
            --this.traverseDepth;
            super.traverseChildren(children);
            ++this.traverseDepth;
        }
    }

    protected void visit(Resource res) {
        if (this.check.isResourceBundle(res)) {
            this.paths.add(res.getPath());
        }
    }
}

