/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.core.impl.tasks;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Collections;
import org.apache.sling.installer.api.tasks.InstallationContext;
import org.apache.sling.installer.api.tasks.ResourceState;
import org.apache.sling.installer.api.tasks.TaskResourceGroup;
import org.apache.sling.installer.core.impl.AbstractInstallTask;
import org.apache.sling.installer.core.impl.tasks.TaskSupport;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class SystemBundleUpdateTask
extends AbstractInstallTask {
    private static final String BUNDLE_UPDATE_ORDER = "01-";
    private static final String SYSTEM_BUNDLE_UPDATE_ORDER = "01-systembundle(0)";

    public SystemBundleUpdateTask(TaskResourceGroup r, TaskSupport taskSupport) {
        super(r, taskSupport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(InstallationContext ctx) {
        Bundle systemBundle = this.getBundleContext().getBundle("System Bundle");
        if (systemBundle == null) {
            this.setFinishedState(ResourceState.IGNORED, null, "Cannot update system bundle!");
            ctx.asyncTaskFailed(this);
            return;
        }
        if (this.getResource() == null) {
            ctx.log("Refreshing system bundle.", new Object[0]);
            this.getBundleRefresher().refreshBundles(ctx, Collections.singletonList(systemBundle), false);
        } else {
            InputStream is = null;
            try {
                is = this.getResource().getInputStream();
                if (is == null) {
                    String message = MessageFormat.format("RegisteredResource provides null InputStream, cannot update system bundle: {0}", this.getResource());
                    this.getLogger().warn(message);
                    this.setFinishedState(ResourceState.IGNORED, null, message);
                    ctx.asyncTaskFailed(this);
                } else {
                    try {
                        systemBundle.update(is);
                    }
                    catch (BundleException e) {
                        String message = MessageFormat.format("Updating system bundle failed due to {0} - unable to retry: {1}", e.getLocalizedMessage(), this);
                        this.getLogger().warn(message, (Throwable)e);
                        this.setFinishedState(ResourceState.IGNORED, null, message);
                        ctx.asyncTaskFailed(this);
                    }
                }
            }
            catch (IOException e) {
                String message = MessageFormat.format("Removing failing task due to  due to {0} - unable to retry: {1}", e.getLocalizedMessage(), this);
                this.getLogger().warn(message, (Throwable)e);
                this.setFinishedState(ResourceState.IGNORED, null, message);
                ctx.asyncTaskFailed(this);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    @Override
    public boolean isAsynchronousTask() {
        return true;
    }

    @Override
    public String getSortKey() {
        if (this.getResource() == null) {
            return SYSTEM_BUNDLE_UPDATE_ORDER;
        }
        return BUNDLE_UPDATE_ORDER + this.getResource().getURL();
    }
}

