/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.provider.file.impl;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.sling.installer.provider.file.impl.ScanConfiguration;
import org.apache.sling.installer.provider.file.impl.ServicesListener;
import org.osgi.annotation.bundle.Header;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

@Header(name="Bundle-Activator", value="${@class}")
public class Activator
implements BundleActivator {
    public static final String KEY_DIR = "sling.fileinstall.dir";
    public static final String KEY_DELAY = "sling.fileinstall.interval";
    public static final String KEY_WRITEBACK = "sling.fileinstall.writeback";
    public static final String KEY_AUTOCREATE_DIR = "sling.fileinstall.dir.autocreate";
    private ServicesListener servicesListener;

    public void start(BundleContext context) {
        ArrayList<ScanConfiguration> configs = new ArrayList<ScanConfiguration>();
        String dir = Activator.getProp(context, KEY_DIR);
        if (dir != null) {
            Long delay = null;
            String interval = Activator.getProp(context, KEY_DELAY);
            if (interval != null) {
                delay = Long.valueOf(interval.toString());
            }
            StringTokenizer st = new StringTokenizer(dir.toString(), ",");
            while (st.hasMoreTokens()) {
                ScanConfiguration sc = new ScanConfiguration();
                sc.directory = st.nextToken();
                sc.scanInterval = delay;
                configs.add(sc);
            }
        }
        this.servicesListener = new ServicesListener(context, configs);
    }

    public void stop(BundleContext context) {
        this.servicesListener.deactivate();
        this.servicesListener = null;
    }

    public static String getProp(BundleContext bundleContext, String key) {
        String value = bundleContext.getProperty(key);
        if (value == null) {
            value = System.getProperty(key.toUpperCase().replace('.', '_'));
        }
        return value;
    }
}

