/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.contentparser;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.apache.sling.jcr.contentparser.JsonParserFeature;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class ParserOptions {
    public static final String DEFAULT_PRIMARY_TYPE = "nt:unstructured";
    public static final Set<String> DEFAULT_REMOVE_PROPERTY_NAME_PREFIXES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("jcr:reference:", "jcr:path:", "jcr:name:", "jcr:uri:")));
    public static final Set<String> DEFAULT_IGNORE_RESOURCE_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("security:acl", "security:principals")));
    public static final EnumSet<JsonParserFeature> DEFAULT_JSON_PARSER_FEATURES = EnumSet.of(JsonParserFeature.COMMENTS);
    private String defaultPrimaryType = "nt:unstructured";
    private boolean detectCalendarValues;
    private Set<String> ignorePropertyNames;
    private Set<String> ignoreResourceNames = DEFAULT_IGNORE_RESOURCE_NAMES;
    private Set<String> removePropertyNamePrefixes = DEFAULT_REMOVE_PROPERTY_NAME_PREFIXES;
    private EnumSet<JsonParserFeature> jsonParserFeatures = DEFAULT_JSON_PARSER_FEATURES;

    public ParserOptions defaultPrimaryType(String value) {
        this.defaultPrimaryType = value;
        return this;
    }

    public String getDefaultPrimaryType() {
        return this.defaultPrimaryType;
    }

    public ParserOptions detectCalendarValues(boolean value) {
        this.detectCalendarValues = value;
        return this;
    }

    public boolean isDetectCalendarValues() {
        return this.detectCalendarValues;
    }

    public ParserOptions ignorePropertyNames(Set<String> value) {
        this.ignorePropertyNames = value;
        return this;
    }

    public Set<String> getIgnorePropertyNames() {
        return this.ignorePropertyNames;
    }

    public ParserOptions ignoreResourceNames(Set<String> value) {
        this.ignoreResourceNames = value;
        return this;
    }

    public Set<String> getIgnoreResourceNames() {
        return this.ignoreResourceNames;
    }

    public ParserOptions removePropertyNamePrefixes(Set<String> value) {
        this.removePropertyNamePrefixes = value;
        return this;
    }

    public Set<String> getRemovePropertyNamePrefixes() {
        return this.removePropertyNamePrefixes;
    }

    public ParserOptions jsonParserFeatures(EnumSet<JsonParserFeature> value) {
        this.jsonParserFeatures = value;
        return this;
    }

    public ParserOptions jsonParserFeatures(JsonParserFeature ... value) {
        this.jsonParserFeatures = EnumSet.copyOf(Arrays.asList(value));
        return this;
    }

    public EnumSet<JsonParserFeature> getJsonParserFeatures() {
        return this.jsonParserFeatures;
    }
}

