/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.contentparser.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.sling.jcr.contentparser.ContentHandler;
import org.apache.sling.jcr.contentparser.ContentParser;
import org.apache.sling.jcr.contentparser.ParseException;
import org.apache.sling.jcr.contentparser.ParserOptions;
import org.apache.sling.jcr.contentparser.impl.JcrXmlValueConverter;
import org.apache.sling.jcr.contentparser.impl.ParserHelper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public final class JcrXmlContentParser
implements ContentParser {
    private final ParserHelper helper;
    private final SAXParserFactory saxParserFactory;

    public JcrXmlContentParser(ParserOptions options) {
        this.helper = new ParserHelper(options);
        this.saxParserFactory = SAXParserFactory.newInstance();
        this.saxParserFactory.setNamespaceAware(true);
    }

    @Override
    public void parse(ContentHandler handler, InputStream is) throws IOException, ParseException {
        try {
            XmlHandler xmlHandler = new XmlHandler(handler);
            SAXParser parser = this.saxParserFactory.newSAXParser();
            parser.parse(is, (DefaultHandler)xmlHandler);
            if (xmlHandler.hasError()) {
                throw xmlHandler.getError();
            }
        }
        catch (ParserConfigurationException | SAXException ex) {
            throw new ParseException("Error parsing JCR XML content.", ex);
        }
    }

    static String decodeName(String qname) {
        return ISO9075.decode((String)qname);
    }

    class XmlHandler
    extends DefaultHandler {
        private final ContentHandler contentHandler;
        private final Deque<String> paths = new ArrayDeque<String>();
        private final Set<String> ignoredPaths = new HashSet<String>();
        private SAXParseException error;

        public XmlHandler(ContentHandler contentHandler) {
            this.contentHandler = contentHandler;
        }

        public boolean hasError() {
            return this.error != null;
        }

        public SAXParseException getError() {
            return this.error;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String path;
            String resourceName = JcrXmlContentParser.decodeName(qName);
            if (this.paths.isEmpty()) {
                path = "/";
            } else {
                path = JcrXmlContentParser.this.helper.concatenatePath(this.paths.peek(), resourceName);
                if (JcrXmlContentParser.this.helper.ignoreResource(resourceName)) {
                    this.ignoredPaths.add(path);
                }
            }
            this.paths.push(path);
            if (this.isIgnoredPath(path)) {
                return;
            }
            HashMap<String, Object> properties = new HashMap<String, Object>();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Object value;
                String propertyName = JcrXmlContentParser.this.helper.cleanupPropertyName(JcrXmlContentParser.decodeName(attributes.getQName(i)));
                if (JcrXmlContentParser.this.helper.ignoreProperty(propertyName) || (value = JcrXmlValueConverter.parseValue(propertyName, attributes.getValue(i))) == null) continue;
                properties.put(propertyName, value);
            }
            JcrXmlContentParser.this.helper.ensureDefaultPrimaryType(properties);
            this.contentHandler.resource(path, properties);
        }

        private boolean isIgnoredPath(String path) {
            if (StringUtils.isEmpty((CharSequence)path)) {
                return false;
            }
            if (this.ignoredPaths.contains(path)) {
                return true;
            }
            String parentPath = StringUtils.substringBeforeLast((String)path, (String)"/");
            return this.isIgnoredPath(parentPath);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.paths.pop();
        }

        @Override
        public void error(SAXParseException ex) throws SAXException {
            this.error = ex;
        }

        @Override
        public void fatalError(SAXParseException ex) throws SAXException {
            this.error = ex;
        }
    }
}

