/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import org.apache.jackrabbit.api.observation.JackrabbitEventFilter;
import org.apache.jackrabbit.api.observation.JackrabbitObservationManager;
import org.apache.jackrabbit.oak.jcr.observation.filter.FilterFactory;
import org.apache.jackrabbit.oak.jcr.observation.filter.OakEventFilter;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.spi.resource.provider.ObservationReporter;
import org.apache.sling.spi.resource.provider.ObserverConfiguration;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrListenerBaseConfig
implements Closeable {
    private final Logger logger = LoggerFactory.getLogger(JcrListenerBaseConfig.class);
    private final Session session;
    private final ObservationReporter reporter;

    public JcrListenerBaseConfig(@NotNull ObservationReporter reporter, @NotNull SlingRepository repository) throws RepositoryException {
        this.reporter = reporter;
        this.session = repository.loginService("observation", repository.getDefaultWorkspace());
    }

    @Override
    public void close() {
        this.session.logout();
    }

    public void register(@NotNull EventListener listener, @NotNull ObserverConfiguration config) throws RepositoryException {
        OakEventFilter filter;
        ObservationManager mgr = this.session.getWorkspace().getObservationManager();
        if (mgr instanceof JackrabbitObservationManager) {
            filter = FilterFactory.wrap((JackrabbitEventFilter)new JackrabbitEventFilter());
            JcrListenerBaseConfig.setFilterPaths(filter, config);
            Set excludePaths = config.getExcludedPaths().toStringSet();
            if (!excludePaths.isEmpty()) {
                filter.setExcludedPaths(excludePaths.toArray(new String[0]));
            }
        } else {
            throw new RepositoryException("Observation manager is not a JackrabbitObservationManager");
        }
        filter.setIsDeep(true);
        filter.setNoExternal(!config.includeExternal());
        filter.setEventTypes(JcrListenerBaseConfig.getTypes(config));
        filter.withNodeTypeAggregate(new String[]{"nt:file"}, new String[]{"", "jcr:content"});
        filter.withIncludeAncestorsRemove();
        ((JackrabbitObservationManager)mgr).addEventListener(listener, (JackrabbitEventFilter)filter);
    }

    protected static void setFilterPaths(@NotNull OakEventFilter filter, @NotNull ObserverConfiguration config) {
        Set paths = config.getPaths().toStringSet();
        ArrayList<String> pathList = new ArrayList<String>(paths.size());
        ArrayList<String> globList = new ArrayList<String>(paths.size());
        for (String p : paths) {
            if (p.startsWith("glob:")) {
                globList.add(p.substring("glob:".length()));
                continue;
            }
            pathList.add(p);
        }
        if (!globList.isEmpty()) {
            filter.withIncludeGlobPaths(globList.toArray(new String[0]));
        }
        if (!pathList.isEmpty()) {
            filter.setAdditionalPaths(pathList.toArray(new String[0]));
        }
    }

    private static int getTypes(@NotNull ObserverConfiguration c) {
        int result = 0;
        for (ResourceChange.ChangeType t : c.getChangeTypes()) {
            switch (t) {
                case ADDED: {
                    result |= 1;
                    break;
                }
                case REMOVED: {
                    result |= 2;
                    break;
                }
                case CHANGED: {
                    result |= 4;
                    result |= 0x10;
                    result |= 8;
                    break;
                }
            }
        }
        return result;
    }

    public void unregister(EventListener listener) {
        try {
            this.session.getWorkspace().getObservationManager().removeEventListener(listener);
        }
        catch (RepositoryException e) {
            this.logger.warn("Unable to remove session listener: " + this, (Throwable)e);
        }
    }

    @NotNull
    public ObservationReporter getReporter() {
        return this.reporter;
    }
}

