/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.launchpad.testservices.servlets;

import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;

@Component(immediate=true, service={Servlet.class}, property={"service.description:String=Exported packages Test Servlet", "service.vendor:String=The Apache Software Foundation", "sling.servlet.resourceTypes:String=sling/servlet/default", "sling.servlet.selectors:String=EXPORTED_PACKAGES", "sling.servlet.extensions:String=txt"})
public class ExportedPackageServlet
extends SlingSafeMethodsServlet {
    @Reference
    private PackageAdmin packageAdmin;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        String packName = request.getParameter("package");
        ExportedPackage p = this.packageAdmin.getExportedPackage(packName);
        if (p == null) {
            response.sendError(404, "Package not found: " + packName);
        } else {
            response.setContentType("text/plain");
            response.setCharacterEncoding("UTF-8");
            response.getWriter().write("PACKAGE FOUND: ");
            response.getWriter().write(p.toString());
            response.getWriter().flush();
        }
    }
}

