/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.nosql.generic.resource.impl;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.resource.ModifyingResourceProvider;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.QueriableResourceProvider;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceProvider;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.nosql.generic.adapter.NoSqlAdapter;
import org.apache.sling.nosql.generic.adapter.NoSqlData;
import org.apache.sling.nosql.generic.resource.impl.NoSqlResource;
import org.apache.sling.nosql.generic.resource.impl.NoSqlValueMap;
import org.apache.sling.nosql.generic.resource.impl.PathUtil;
import org.apache.sling.nosql.generic.resource.impl.ValueMapConvertingNoSqlAdapter;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class NoSqlResourceProvider
implements ResourceProvider,
ModifyingResourceProvider,
QueriableResourceProvider {
    private static final String ROOT_PATH = "/";
    private final NoSqlAdapter adapter;
    private final EventAdmin eventAdmin;
    private final Map<String, NoSqlData> changedResources = new LinkedHashMap<String, NoSqlData>();
    private final Set<String> deletedResources = new HashSet<String>();

    public NoSqlResourceProvider(NoSqlAdapter adapter, EventAdmin eventAdmin) {
        this.adapter = new ValueMapConvertingNoSqlAdapter(adapter);
        this.eventAdmin = eventAdmin;
    }

    public Resource getResource(ResourceResolver resourceResolver, String path) {
        if (!this.adapter.validPath(path)) {
            return null;
        }
        if (!this.deletedResources.isEmpty()) {
            for (String deletedPath : this.deletedResources) {
                Pattern deletedPathPattern = PathUtil.getSameOrDescendantPathPattern(deletedPath);
                if (!deletedPathPattern.matcher(path).matches()) continue;
                return null;
            }
        }
        if (this.changedResources.containsKey(path)) {
            return new NoSqlResource(this.changedResources.get(path), resourceResolver, this);
        }
        NoSqlData data = this.adapter.get(path);
        if (data != null) {
            return new NoSqlResource(data, resourceResolver, this);
        }
        if (ROOT_PATH.equals(path)) {
            NoSqlData rootData = new NoSqlData(ROOT_PATH, new HashMap<String, Object>());
            return new NoSqlResource(rootData, resourceResolver, this);
        }
        return null;
    }

    public Resource getResource(ResourceResolver resourceResolver, HttpServletRequest request, String path) {
        return this.getResource(resourceResolver, path);
    }

    public Iterator<Resource> listChildren(Resource parent) {
        TreeMap<String, NoSqlResource> children = new TreeMap<String, NoSqlResource>();
        Iterator<NoSqlData> fromAdapter = this.adapter.getChildren(parent.getPath());
        while (fromAdapter.hasNext()) {
            NoSqlData item = fromAdapter.next();
            if (this.isDeleted(item.getPath()) || this.changedResources.containsKey(item.getPath())) continue;
            children.put(item.getPath(), new NoSqlResource(item, parent.getResourceResolver(), this));
        }
        Pattern childPathPattern = PathUtil.getChildPathPattern(parent.getPath());
        for (NoSqlData item : this.changedResources.values()) {
            if (!childPathPattern.matcher(item.getPath()).matches()) continue;
            children.put(item.getPath(), new NoSqlResource(item, parent.getResourceResolver(), this));
        }
        return children.values().iterator();
    }

    private boolean isDeleted(String path) {
        for (String deletedPath : this.deletedResources) {
            if (!path.equals(deletedPath) && !path.equals(deletedPath + ROOT_PATH)) continue;
            return true;
        }
        return false;
    }

    public Resource create(ResourceResolver resolver, String path, Map<String, Object> properties) throws PersistenceException {
        boolean exists;
        if (ROOT_PATH.equals(path) || !this.adapter.validPath(path)) {
            throw new PersistenceException("Illegal path - unable to create resource at " + path, null, path, null);
        }
        boolean deleted = this.deletedResources.remove(path);
        boolean bl = exists = this.changedResources.containsKey(path) || this.adapter.get(path) != null;
        if (!deleted && exists) {
            throw new PersistenceException("Resource already exists at " + path, null, path, null);
        }
        HashMap<String, Object> writableMap = properties != null ? new HashMap<String, Object>(properties) : new HashMap();
        NoSqlData data = new NoSqlData(path, NoSqlValueMap.convertForWriteAll(writableMap));
        this.changedResources.put(path, data);
        return new NoSqlResource(data, resolver, this);
    }

    public void delete(ResourceResolver resolver, String path) throws PersistenceException {
        if (ROOT_PATH.equals(path) || !this.adapter.validPath(path)) {
            throw new PersistenceException("Unable to delete resource at {}" + path, null, path, null);
        }
        Pattern pathsToDeletePattern = PathUtil.getSameOrDescendantPathPattern(path);
        Iterator<String> deletedResourcesIterator = this.deletedResources.iterator();
        while (deletedResourcesIterator.hasNext()) {
            String deletedPath = deletedResourcesIterator.next();
            if (!pathsToDeletePattern.matcher(deletedPath).matches()) continue;
            deletedResourcesIterator.remove();
        }
        Iterator<Map.Entry<String, NoSqlData>> changeResourcesIterator = this.changedResources.entrySet().iterator();
        while (changeResourcesIterator.hasNext()) {
            Map.Entry<String, NoSqlData> entry = changeResourcesIterator.next();
            if (!pathsToDeletePattern.matcher(entry.getKey()).matches()) continue;
            changeResourcesIterator.remove();
        }
        this.deletedResources.add(path);
    }

    public void revert(ResourceResolver resolver) {
        this.changedResources.clear();
        this.deletedResources.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(ResourceResolver resolver) throws PersistenceException {
        try {
            for (String path : this.deletedResources) {
                this.adapter.deleteRecursive(path);
                this.notifyRemoved(path);
            }
            for (NoSqlData item : this.changedResources.values()) {
                boolean created = this.adapter.store(item);
                if (created) {
                    this.notifyAdded(item.getPath());
                    continue;
                }
                this.notifyUpdated(item.getPath());
            }
        }
        finally {
            this.revert(resolver);
        }
    }

    public boolean hasChanges(ResourceResolver resolver) {
        return !this.changedResources.isEmpty() || !this.deletedResources.isEmpty();
    }

    void markAsChanged(Resource resource) {
        this.changedResources.put(resource.getPath(), new NoSqlData(resource.getPath(), (Map<String, Object>)resource.getValueMap()));
    }

    private void notifyAdded(String path) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("path", path);
        Event event = new Event("org/apache/sling/api/resource/Resource/ADDED", props);
        this.eventAdmin.postEvent(event);
    }

    private void notifyUpdated(String path) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("path", path);
        Event event = new Event("org/apache/sling/api/resource/Resource/CHANGED", props);
        this.eventAdmin.postEvent(event);
    }

    private void notifyRemoved(String path) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("path", path);
        Event event = new Event("org/apache/sling/api/resource/Resource/REMOVED", props);
        this.eventAdmin.postEvent(event);
    }

    public Iterator<Resource> findResources(final ResourceResolver resolver, String query, String language) {
        final Iterator<NoSqlData> result = this.adapter.query(query, language);
        if (result == null) {
            return null;
        }
        return new Iterator<Resource>(){

            @Override
            public boolean hasNext() {
                return result.hasNext();
            }

            @Override
            public Resource next() {
                return new NoSqlResource((NoSqlData)result.next(), resolver, NoSqlResourceProvider.this);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator<ValueMap> queryResources(ResourceResolver resolver, String query, String language) {
        final Iterator<Resource> result = this.findResources(resolver, query, language);
        if (result == null) {
            return null;
        }
        return new Iterator<ValueMap>(){

            @Override
            public boolean hasNext() {
                return result.hasNext();
            }

            @Override
            public ValueMap next() {
                return ((Resource)result.next()).getValueMap();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

