/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.pipes.CommandExecutor;
import org.apache.sling.pipes.PipeBuilder;
import org.apache.sling.pipes.Plumber;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={GogoCommands.class}, property={"osgi.command.scope=pipe", "osgi.command.function=build", "osgi.command.function=run", "osgi.command.function=execute", "osgi.command.function=help"})
public class GogoCommands {
    static final String INPUT = "-";
    static final String COMMAND_HELP_START = "\nSling Pipes Help\nAvailable commands are \n\n- execute <path> <options>(execute a pipe already built at a given path), if path is '-' then previous pipe token is used,\n- build (build pipe as configured in arguments)\n- run (run pipe as configured in arguments)\n- help (print(). this help)\n\nfor pipe configured in argument, do 'pipe:<run|build|runAsync> <pipe token> (/ <pipe token> )*\n";
    @Reference
    ResourceResolverFactory factory;
    @Reference
    CommandExecutor commandExecutor;
    @Reference
    Plumber plumber;

    PrintStream print() {
        return System.out;
    }

    public void run(String ... cmds) throws LoginException, InvocationTargetException, IllegalAccessException {
        try (ResourceResolver resolver = this.factory.getServiceResourceResolver(this.plumber.getServiceUser());){
            PipeBuilder builder = this.commandExecutor.parse(resolver, cmds);
            this.print().println(builder.run());
        }
    }

    public void build(String ... cmds) throws LoginException, InvocationTargetException, IllegalAccessException, PersistenceException {
        try (ResourceResolver resolver = this.factory.getServiceResourceResolver(this.plumber.getServiceUser());){
            PipeBuilder builder = this.commandExecutor.parse(resolver, cmds);
            this.print().println(builder.build().getResource().getPath());
        }
    }

    public void execute(String path, String ... options) throws IOException, LoginException {
        String computedPath = INPUT.equals(path) ? IOUtils.toString((InputStream)System.in).trim() : path;
        try (ResourceResolver resolver = this.factory.getServiceResourceResolver(this.plumber.getServiceUser());){
            this.print().println(this.commandExecutor.execute(resolver, computedPath, options));
        }
    }

    public void help() {
        this.print().println(COMMAND_HELP_START + this.commandExecutor.help());
    }
}

