/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourcemerger.impl;

import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HideItemPredicate {
    private Boolean isAllowList = null;
    private boolean isWildcard = false;
    private final Set<String> names = new HashSet<String>();
    private static final Logger LOGGER = LoggerFactory.getLogger(HideItemPredicate.class);

    public HideItemPredicate(String[] settings, String propertyPath) {
        for (String value : settings) {
            if (value.equals("*")) {
                this.isWildcard = true;
                continue;
            }
            SettingValue setting = HideItemPredicate.parseSetting(value);
            if (this.isAllowList == null) {
                this.isAllowList = !setting.isNegated();
            } else if (this.isAllowList == setting.isNegated) {
                LOGGER.warn("Negated and non-negated values mixed in {}, skipping value '{}'", (Object)propertyPath, (Object)setting);
                continue;
            }
            this.names.add(setting.getName());
        }
        if (this.isAllowList == null) {
            this.isAllowList = true;
        }
    }

    static SettingValue parseSetting(String value) {
        int index;
        if (!value.startsWith("!")) {
            return new SettingValue(value, false);
        }
        for (index = 0; index < value.length() && value.charAt(index) == '!'; ++index) {
        }
        if (index % 2 == 1) {
            return new SettingValue(value.substring(index), true);
        }
        return new SettingValue(value.substring(index / 2), false);
    }

    public boolean testItem(String name, boolean isLocal) {
        if (isLocal) {
            if (this.names.contains(name)) {
                return this.isAllowList;
            }
            return this.isAllowList == false;
        }
        if (this.names.contains(name)) {
            return this.isAllowList;
        }
        return this.isWildcard;
    }

    boolean isWildcard() {
        return this.isWildcard;
    }

    private static class SettingValue {
        private final String name;
        private final boolean isNegated;

        public SettingValue(String name, boolean isNegated) {
            this.name = name;
            this.isNegated = isNegated;
        }

        public String getName() {
            return this.name;
        }

        public boolean isNegated() {
            return this.isNegated;
        }
    }
}

