/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.providers.tree;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.resourceresolver.impl.providers.tree.Node;
import org.apache.sling.resourceresolver.impl.providers.tree.PathSegmentIterator;
import org.apache.sling.resourceresolver.impl.providers.tree.Pathable;

public class PathTree<T extends Pathable> {
    private Node<T> root = new Node();

    public PathTree(List<T> values) {
        for (Pathable v : values) {
            this.addNewValue(v);
        }
    }

    private void addNewValue(T value) {
        Node<T> node = this.root;
        for (String segment : StringUtils.split((String)value.getPath(), (char)'/')) {
            node = node.hasChild(segment) ? node.getChild(segment) : node.addChild(segment);
        }
        node.setValue(value);
    }

    public Node<T> getBestMatchingNode(String path) {
        String segment;
        if (path == null || path.isEmpty() || path.charAt(0) != '/') {
            return null;
        }
        Node<T> result = this.root.getValue() != null ? this.root : null;
        Node<T> node = this.root;
        PathSegmentIterator it = new PathSegmentIterator(path, 1);
        while (it.hasNext() && (node = node.getChild(segment = (String)it.next())) != null) {
            if (node.getValue() == null) continue;
            result = node;
        }
        return result;
    }

    public Node<T> getNode(String path) {
        if (path == null || path.isEmpty() || path.charAt(0) != '/') {
            return null;
        }
        Node<T> node = this.root;
        PathSegmentIterator it = new PathSegmentIterator(path, 1);
        while (it.hasNext()) {
            String segment = (String)it.next();
            if ((node = node.getChild(segment)) != null) continue;
            return null;
        }
        return node;
    }
}

