/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.starter.testservices.handlers;

import java.io.IOException;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.server.io.ExportContext;
import org.apache.jackrabbit.server.io.IOHandler;
import org.apache.jackrabbit.server.io.IOManager;
import org.apache.jackrabbit.server.io.ImportContext;
import org.apache.jackrabbit.server.io.PropertyExportContext;
import org.apache.jackrabbit.server.io.PropertyHandler;
import org.apache.jackrabbit.server.io.PropertyImportContext;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.property.PropEntry;

public abstract class AbstractHandler
implements IOHandler,
PropertyHandler {
    private static final String HANDLER_IDENTIFIER = "handler-identifier";
    private IOManager ioManager;

    public IOManager getIOManager() {
        return this.ioManager;
    }

    public void setIOManager(IOManager ioManager) {
        this.ioManager = ioManager;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public boolean canImport(ImportContext context, DavResource davResource) {
        return this.canImport(context, davResource.isCollection());
    }

    public boolean canImport(ImportContext context, boolean b) {
        return false;
    }

    public boolean importContent(ImportContext context, DavResource davResource) throws IOException {
        return this.importContent(context, davResource.isCollection());
    }

    public boolean importContent(ImportContext context, boolean b) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean canExport(ExportContext context, boolean b) {
        try {
            Node node = (Node)context.getExportRoot();
            return this.matches(node.getPath());
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean canExport(ExportContext context, DavResource davResource) {
        return this.canExport(context, davResource.isCollection());
    }

    public boolean exportContent(ExportContext context, DavResource davResource) throws IOException {
        return this.exportContent(context, davResource.isCollection());
    }

    public boolean exportContent(ExportContext context, boolean b) throws IOException {
        context.setProperty((Object)HANDLER_IDENTIFIER, (Object)this.getIdentifier());
        return true;
    }

    public boolean canExport(PropertyExportContext context, boolean b) {
        try {
            Node node = (Node)context.getExportRoot();
            return this.matches(node.getPath());
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean exportProperties(PropertyExportContext context, boolean b) throws RepositoryException {
        context.setProperty((Object)HANDLER_IDENTIFIER, (Object)this.getIdentifier());
        return true;
    }

    public boolean canImport(PropertyImportContext context, boolean b) {
        return false;
    }

    public Map<? extends PropEntry, ?> importProperties(PropertyImportContext context, boolean b) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public String getIdentifier() {
        return this.getHandlerName() + "-";
    }

    public boolean matches(String path) {
        return path != null && path.contains(this.getHandlerName());
    }

    public abstract String getHandlerName();
}

