/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.starter.testservices.serversidetests;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.junit.annotations.SlingAnnotationsTestRunner;
import org.apache.sling.junit.annotations.TestReference;
import org.apache.sling.starter.testservices.events.EventsCounter;
import org.apache.sling.starter.testservices.exported.MappingsFacade;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=SlingAnnotationsTestRunner.class)
public class MappingEventsTest {
    public static final String PROP_REDIRECT_EXTERNAL = "sling:redirect";
    private static final Logger logger = LoggerFactory.getLogger(MappingEventsTest.class);
    private static Session session;
    private Node mapRoot;
    private static List<String> toDelete;
    private static final int N_STEPS = 20;
    @TestReference
    private EventsCounter eventsCounter;
    @TestReference
    private SlingRepository repository;

    private Node maybeCreateNode(Node parent, String name, String type) throws RepositoryException {
        if (parent.hasNode(name)) {
            return parent.getNode(name);
        }
        return parent.addNode(name, type);
    }

    @Before
    public synchronized void setup() throws Exception {
        session = this.repository.loginAdministrative(null);
        Node rootNode = this.maybeCreateNode(session.getRootNode(), "content", "nt:unstructured");
        session.save();
        Assert.assertTrue((String)"toDelete should be empty before test", (boolean)toDelete.isEmpty());
        this.mapRoot = this.maybeCreateNode(session.getRootNode(), "etc", "nt:folder");
        Node map = this.maybeCreateNode(this.mapRoot, "map", "sling:Mapping");
        Node http = this.maybeCreateNode(map, "http", "sling:Mapping");
        this.maybeCreateNode(http, "localhost.80", "sling:Mapping");
        Node https = this.maybeCreateNode(map, "https", "sling:Mapping");
        this.maybeCreateNode(https, "localhost.443", "sling:Mapping");
        toDelete.add(map.getPath());
        toDelete.add(rootNode.getPath());
    }

    @After
    public void deleteTestNodes() throws Exception {
        logger.debug("{} test done, deleting test nodes", (Object)MappingEventsTest.class.getSimpleName());
        try {
            for (String path : toDelete) {
                if (!session.itemExists(path)) continue;
                session.getItem(path).remove();
            }
            toDelete.clear();
            session.save();
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSaveMappings() throws Exception {
        Node base = this.mapRoot.getNode("map/https/localhost.443");
        MappingsFacade f = new MappingsFacade(this.eventsCounter);
        try {
            int count = 20;
            while (count-- > 0) {
                base.setProperty(PROP_REDIRECT_EXTERNAL, "http://somehost." + count);
                String result = f.saveMappings(session);
                if (result == null) continue;
                Assert.fail((String)result);
            }
        }
        finally {
            base.setProperty(PROP_REDIRECT_EXTERNAL, "");
            session.save();
        }
    }

    @Test
    public void testVanityPaths() throws Exception {
        MappingsFacade f = new MappingsFacade(this.eventsCounter);
        Node vanityTest = this.maybeCreateNode(session.getRootNode(), "vanityTest", "sling:Folder");
        toDelete.add(vanityTest.getPath());
        int count = 20;
        while (count-- > 0) {
            String[] paths = new String[]{"one", "two", "three_" + count};
            vanityTest.setProperty("sling:vanityPath", paths);
            String result = f.saveMappings(session);
            if (result == null) continue;
            Assert.fail((String)result);
        }
    }

    static {
        toDelete = new ArrayList<String>();
    }
}

