/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.junit.rules.util;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.testing.junit.rules.util.Match;

public class IgnoreTestsConfig {
    public static final String IGNORE_LIST_PROP = "sling.it.ignorelist";
    public static final String RUN_IGNORE_LIST_PROP = "sling.it.ignorelist.run";
    private final int numberOfIgnoreLists = 3;
    private final boolean runIgnoreList;
    private static IgnoreTestsConfig INSTANCE;
    private Map<String, String> ignoreTokens = new HashMap<String, String>();

    public static IgnoreTestsConfig get() {
        if (INSTANCE == null) {
            INSTANCE = new IgnoreTestsConfig();
        }
        return INSTANCE;
    }

    public static void reCreate() {
        INSTANCE = new IgnoreTestsConfig();
    }

    private IgnoreTestsConfig() {
        for (int i = 0; i <= 3; ++i) {
            StringTokenizer st = new StringTokenizer(System.getProperty(IGNORE_LIST_PROP, ""), ",");
            while (st.hasMoreElements()) {
                String token = st.nextToken();
                String[] pair = token.split(":");
                String ignoreToken = pair.length > 0 ? pair[0] : "";
                String reason = pair.length > 1 ? pair[1] : "";
                this.ignoreTokens.put(ignoreToken.trim(), reason.trim());
            }
        }
        this.runIgnoreList = System.getProperty(RUN_IGNORE_LIST_PROP) != null;
    }

    public Match match(String fqdn) {
        if (null == fqdn || "".equals(fqdn)) {
            throw new IllegalArgumentException("The ignore class/method String must not be null or empty");
        }
        String className = StringUtils.substringBefore((String)fqdn, (String)"#");
        Match match = this.matchToken(fqdn);
        if (!match.isIgnored() && fqdn.indexOf(35) > 0) {
            return this.matchToken(className);
        }
        return match;
    }

    private Match matchToken(String matchToken) {
        if (!this.runIgnoreList) {
            for (String ignoreToken : this.ignoreTokens.keySet()) {
                if (!IgnoreTestsConfig.asteriskMatch(ignoreToken, matchToken)) continue;
                return new Match(true, this.ignoreTokens.get(ignoreToken));
            }
            return new Match(false);
        }
        for (String ignoreToken : this.ignoreTokens.keySet()) {
            if (!IgnoreTestsConfig.asteriskMatch(ignoreToken, matchToken)) continue;
            return new Match(false, this.ignoreTokens.get(ignoreToken));
        }
        return new Match(true, "Running tests in ignorelist only");
    }

    private static String createRegexFromGlob(String glob) {
        String out = "^";
        block6: for (int i = 0; i < glob.length(); ++i) {
            char c = glob.charAt(i);
            switch (c) {
                case '*': {
                    out = out + ".*";
                    continue block6;
                }
                case '?': {
                    out = out + '.';
                    continue block6;
                }
                case '.': {
                    out = out + "\\.";
                    continue block6;
                }
                case '\\': {
                    out = out + "\\\\";
                    continue block6;
                }
                default: {
                    out = out + c;
                }
            }
        }
        out = out + '$';
        return out;
    }

    public static boolean asteriskMatch(String pattern, String text) {
        return text.matches(IgnoreTestsConfig.createRegexFromGlob(pattern));
    }
}

