/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.lock;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jcr.UnsupportedRepositoryOperationException;
import org.apache.jackrabbit.oak.jcr.lock.LockManagerImpl;
import org.apache.jackrabbit.oak.jcr.session.NodeImpl;
import org.apache.jackrabbit.oak.jcr.session.SessionImpl;
import org.apache.jackrabbit.oak.jcr.xml.ImporterImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockDeprecation {
    private static final Logger LOG = LoggerFactory.getLogger(LockDeprecation.class);
    private static final String LOCKSUPPORT = System.getProperty("oak.locksupport", "deprecated");
    private static final boolean ISLOCKINGSUPPORTED = !"disabled".equals(LOCKSUPPORT);
    private static final String MAYBEOK = "(invocation might be ok in order to detect locking support)";
    private static final int LOGDEPTH = 5;
    private static AtomicBoolean NOTWARNEDYET = new AtomicBoolean(true);
    private static final Set<String> IGNOREDCLASSES = new HashSet<String>(Arrays.asList(Thread.class.getName(), Method.class.getName(), LockDeprecation.class.getName(), LockManagerImpl.class.getName(), NodeImpl.class.getName(), SessionImpl.class.getName()));
    private static final Set<String> ACCEPTEDCLASSES = new HashSet<String>(Arrays.asList(ImporterImpl.class.getName()));

    private LockDeprecation() {
    }

    public static void handleCall(String operation) throws UnsupportedRepositoryOperationException {
        if (!ISLOCKINGSUPPORTED) {
            throw new UnsupportedRepositoryOperationException("Support for JCR Locking is disabled (see OAK-6421 for further information)");
        }
        boolean firstInvocation = NOTWARNEDYET.getAndSet(false);
        String message = LockDeprecation.createLogMessage(operation);
        if (firstInvocation && !message.endsWith(MAYBEOK)) {
            String explanation = "Support for JCR Locking is deprecated and will be disabled in a future version of Jackrabbit Oak (see OAK-6421 for further information)";
            LOG.warn(explanation + " - " + message);
        } else if (LOG.isTraceEnabled()) {
            LOG.trace(message);
        }
    }

    public static final boolean isLockingSupported() {
        return ISLOCKINGSUPPORTED;
    }

    private static String createLogMessage(String operation) {
        boolean whitelistThisCall = false;
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        StringBuilder b = new StringBuilder();
        b.append("operation '" + operation + "' called from:");
        int depth = 0;
        for (StackTraceElement e : elements) {
            if (depth >= 5) continue;
            String cn = e.getClassName();
            whitelistThisCall |= ACCEPTEDCLASSES.contains(cn);
            if (IGNOREDCLASSES.contains(cn) || cn.startsWith("sun.reflect")) continue;
            b.append(" ").append(e.toString());
            ++depth;
        }
        if (whitelistThisCall) {
            b.append(' ').append(MAYBEOK);
        }
        return b.toString();
    }
}

