/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.progress;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.commons.TimeDurationFormatter;
import org.apache.jackrabbit.oak.commons.time.Stopwatch;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdate;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateCallback;
import org.apache.jackrabbit.oak.plugins.index.NodeTraversalCallback;
import org.apache.jackrabbit.oak.plugins.index.progress.NodeCountEstimator;
import org.apache.jackrabbit.oak.plugins.index.progress.ProgressTrackingEditor;
import org.apache.jackrabbit.oak.plugins.index.progress.SimpleRateEstimator;
import org.apache.jackrabbit.oak.plugins.index.progress.TraversalRateEstimator;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexingProgressReporter
implements NodeTraversalCallback {
    private static final String REINDEX_MSG = "Reindexing";
    private static final String INDEX_MSG = "Incremental indexing";
    private final Logger log = LoggerFactory.getLogger(IndexUpdate.class);
    private Stopwatch watch = Stopwatch.createStarted();
    private final IndexUpdateCallback updateCallback;
    private final NodeTraversalCallback traversalCallback;
    private final Map<String, IndexUpdateState> indexUpdateStates = new HashMap<String, IndexUpdateState>();
    private long traversalCount;
    private String messagePrefix = "Incremental indexing";
    private TraversalRateEstimator traversalRateEstimator = new SimpleRateEstimator();
    private NodeCountEstimator nodeCountEstimator = NodeCountEstimator.NOOP;
    private long estimatedCount;

    public IndexingProgressReporter(IndexUpdateCallback updateCallback, NodeTraversalCallback traversalCallback) {
        this.updateCallback = updateCallback;
        this.traversalCallback = traversalCallback;
    }

    public Editor wrapProgress(Editor editor) {
        return ProgressTrackingEditor.wrap(editor, this);
    }

    public void reindexingTraversalStart(String path) {
        this.estimatedCount = this.nodeCountEstimator.getEstimatedNodeCount(path, this.getReindexedIndexPaths());
        if (this.estimatedCount >= 0L) {
            this.log.info("Estimated node count to be traversed for reindexing under {} is [{}]", (Object)path, (Object)this.estimatedCount);
        }
        this.messagePrefix = REINDEX_MSG;
    }

    public void reindexingTraversalEnd() {
        this.messagePrefix = INDEX_MSG;
    }

    public void setMessagePrefix(String messagePrefix) {
        this.messagePrefix = messagePrefix;
    }

    @Override
    public void traversedNode(NodeTraversalCallback.PathSource pathSource) throws CommitFailedException {
        if (++this.traversalCount % 100000L == 0L) {
            double rate = this.traversalRateEstimator.getNodesTraversedPerSecond();
            String formattedRate = String.format("%1.2f nodes/s, %1.2f nodes/hr", rate, rate * 3600.0);
            String estimate = this.estimatePendingTraversal(rate);
            this.log.info("{} Traversed #{} {} [{}] {}", new Object[]{this.messagePrefix, this.traversalCount, pathSource.getPath(), formattedRate, estimate});
        }
        this.traversalCallback.traversedNode(pathSource);
        this.traversalRateEstimator.traversedNode();
    }

    public void registerIndex(String indexPath, boolean reindexing, long estimatedCount) {
        this.indexUpdateStates.put(indexPath, new IndexUpdateState(indexPath, reindexing, estimatedCount));
    }

    public void indexUpdate(String indexPath) throws CommitFailedException {
        this.indexUpdateStates.get(indexPath).indexUpdate();
    }

    public void logReport() {
        if (this.isReindexingPerformed()) {
            this.log.info(this.getReport());
            this.log.info("Reindexing completed");
        } else if (this.log.isDebugEnabled() && this.somethingIndexed()) {
            this.log.debug(this.getReport());
        }
    }

    public List<String> getReindexStats() {
        return this.indexUpdateStates.values().stream().filter(st -> st.reindex).map(Object::toString).collect(Collectors.toList());
    }

    public boolean isReindexingPerformed() {
        return this.indexUpdateStates.values().stream().anyMatch(st -> st.reindex);
    }

    public Set<String> getUpdatedIndexPaths() {
        return this.indexUpdateStates.keySet();
    }

    public Set<String> getReindexedIndexPaths() {
        return this.indexUpdateStates.values().stream().filter(st -> st.reindex).map(st -> st.indexPath).collect(Collectors.toSet());
    }

    public boolean somethingIndexed() {
        return this.indexUpdateStates.values().stream().anyMatch(st -> st.updateCount.get() > 0L);
    }

    public void setTraversalRateEstimator(TraversalRateEstimator traversalRate) {
        this.traversalRateEstimator = traversalRate;
    }

    public void setNodeCountEstimator(NodeCountEstimator nodeCountEstimator) {
        this.nodeCountEstimator = nodeCountEstimator;
    }

    public void setEstimatedCount(long estimatedCount) {
        this.estimatedCount = estimatedCount;
    }

    public void reset() {
        this.watch = Stopwatch.createStarted();
        this.traversalCount = 0L;
        this.messagePrefix = INDEX_MSG;
    }

    private String estimatePendingTraversal(double nodesPerSecond) {
        if (this.estimatedCount >= 0L) {
            if (this.estimatedCount > this.traversalCount) {
                long pending = this.estimatedCount - this.traversalCount;
                long timeRequired = (long)((double)pending / nodesPerSecond);
                double percentComplete = (double)this.traversalCount / (double)this.estimatedCount * 100.0;
                return String.format("(Elapsed %s, Expected %s, Completed %1.2f%%)", this.watch, TimeDurationFormatter.forLogging().format(timeRequired, TimeUnit.SECONDS), percentComplete);
            }
            return String.format("(Elapsed %s)", this.watch);
        }
        return "";
    }

    private String getReport() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("Indexing report");
        for (IndexUpdateState st : this.indexUpdateStates.values()) {
            if (!this.log.isDebugEnabled() && !st.reindex || st.updateCount.get() <= 0L && !st.reindex) continue;
            pw.printf("    - %s%n", st);
        }
        return sw.toString();
    }

    private class IndexUpdateState {
        final String indexPath;
        final boolean reindex;
        final long estimatedCount;
        final Stopwatch watch = Stopwatch.createStarted();
        AtomicLong updateCount = new AtomicLong(0L);

        public IndexUpdateState(String indexPath, boolean reindex, long estimatedCount) {
            this.indexPath = indexPath;
            this.reindex = reindex;
            this.estimatedCount = estimatedCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void indexUpdate() throws CommitFailedException {
            long count = this.updateCount.incrementAndGet();
            if (count % 10000L == 0L) {
                IndexUpdateState indexUpdateState = this;
                synchronized (indexUpdateState) {
                    IndexingProgressReporter.this.log.info("{} => Indexed {} nodes in {} ...", new Object[]{this.indexPath, count, this.watch});
                    this.watch.reset().start();
                }
            }
            IndexingProgressReporter.this.updateCallback.indexUpdate();
        }

        public String toString() {
            String reindexMarker = this.reindex ? "*" : "";
            return this.indexPath + reindexMarker + "(" + String.valueOf(this.updateCount) + ")";
        }
    }
}

