/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.migration.report;

import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.migration.AbstractDecoratedNodeState;
import org.apache.jackrabbit.oak.plugins.migration.report.Reporter;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReportingNodeState
extends AbstractDecoratedNodeState {
    private final ReportingNodeState parent;
    private final String name;
    private final Reporter reporter;

    public static NodeState wrap(NodeState nodeState, Reporter reporter) {
        return ReportingNodeState.wrapAndReport(null, "/", nodeState, reporter);
    }

    private static NodeState wrapAndReport(@Nullable ReportingNodeState parent, @NotNull String name, @NotNull NodeState delegate, @NotNull Reporter reporter) {
        ReportingNodeState nodeState = new ReportingNodeState(parent, name, delegate, reporter);
        reporter.reportNode(nodeState);
        return nodeState;
    }

    private ReportingNodeState(ReportingNodeState parent, String name, NodeState delegate, Reporter reporter) {
        super(delegate, true);
        this.parent = parent;
        this.name = name;
        this.reporter = reporter;
    }

    public String getPath() {
        if (this.parent == null) {
            return this.name;
        }
        return PathUtils.concat(this.parent.getPath(), this.name);
    }

    @Override
    @NotNull
    protected NodeState decorateChild(@NotNull String name, @NotNull NodeState delegateChild) {
        return ReportingNodeState.wrapAndReport(this, name, delegateChild, this.reporter);
    }

    @Override
    @Nullable
    protected PropertyState decorateProperty(@NotNull PropertyState delegatePropertyState) {
        this.reporter.reportProperty(this, delegatePropertyState.getName());
        return delegatePropertyState;
    }

    @Override
    public String toString() {
        return "ReportingNodeState{" + this.getPath() + ", " + this.delegate.toString() + "}";
    }
}

