/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authentication.user;

import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.jcr.Credentials;
import javax.jcr.GuestCredentials;
import javax.jcr.SimpleCredentials;
import javax.security.auth.login.LoginException;
import org.apache.jackrabbit.oak.api.AuthInfo;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.commons.collections.IterableUtils;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.AbstractLoginModule;
import org.apache.jackrabbit.oak.spi.security.authentication.AuthInfoImpl;
import org.apache.jackrabbit.oak.spi.security.authentication.Authentication;
import org.apache.jackrabbit.oak.spi.security.authentication.ImpersonationCredentials;
import org.apache.jackrabbit.oak.spi.security.authentication.PreAuthenticatedLogin;
import org.apache.jackrabbit.oak.spi.security.user.UserAuthenticationFactory;
import org.apache.jackrabbit.oak.spi.security.user.UserConfiguration;
import org.apache.jackrabbit.oak.spi.security.user.util.UserUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoginModuleImpl
extends AbstractLoginModule {
    private static final Logger log = LoggerFactory.getLogger(LoginModuleImpl.class);
    protected static final Set<Class> SUPPORTED_CREDENTIALS = new HashSet<Class>(3);
    private Credentials credentials;
    private String userId;
    private Principal principal;
    private boolean success;
    private Set<? extends Principal> principals;
    private AuthInfo authInfo;

    @Override
    public boolean login() throws LoginException {
        this.credentials = this.getCredentials();
        PreAuthenticatedLogin preAuthLogin = this.getSharedPreAuthLogin();
        String loginName = this.getLoginId(preAuthLogin);
        Authentication authentication = this.getUserAuthentication(loginName);
        if (authentication != null) {
            this.success = this.authenticate(preAuthLogin, authentication);
            if (this.success) {
                log.debug("Adding Credentials to shared state.");
                this.sharedState.put("org.apache.jackrabbit.credentials", this.credentials);
                log.debug("Adding login name to shared state.");
                this.sharedState.put("javax.security.auth.login.name", loginName);
                this.userId = authentication.getUserId();
                if (this.userId == null) {
                    this.userId = loginName;
                }
                this.principal = authentication.getUserPrincipal();
            }
        } else {
            this.credentials = null;
            this.userId = null;
        }
        return this.success;
    }

    @Override
    public boolean commit() {
        if (!this.success) {
            this.clearState();
            return false;
        }
        this.principals = Collections.emptySet();
        if (this.principal != null) {
            this.principals = this.getPrincipals(this.principal);
        } else if (this.userId != null) {
            this.principals = this.getPrincipals(this.userId);
        }
        this.authInfo = this.createAuthInfo(this.principals);
        if (!this.subject.isReadOnly()) {
            this.subject.getPrincipals().addAll(this.principals);
            if (this.credentials != null) {
                this.subject.getPublicCredentials().add(this.credentials);
            }
            LoginModuleImpl.setAuthInfo(this.authInfo, this.subject);
        } else {
            log.debug("Could not add information to read only subject {}", (Object)this.subject);
        }
        this.closeSystemSession();
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        Set<Object> creds = Stream.of(this.credentials, this.authInfo).filter(Objects::nonNull).collect(Collectors.toSet());
        return this.logout(creds.isEmpty() ? null : creds, this.principals);
    }

    @Override
    @NotNull
    protected Set<Class> getSupportedCredentials() {
        return SUPPORTED_CREDENTIALS;
    }

    @Override
    protected void clearState() {
        super.clearState();
        this.credentials = null;
        this.userId = null;
        this.principal = null;
        this.principals = null;
        this.authInfo = null;
    }

    @Nullable
    private String getLoginId(@Nullable PreAuthenticatedLogin preAuthenticatedLogin) {
        Credentials bc;
        if (preAuthenticatedLogin != null) {
            return preAuthenticatedLogin.getUserId();
        }
        String uid = null;
        if (this.credentials instanceof SimpleCredentials) {
            uid = ((SimpleCredentials)this.credentials).getUserID();
        } else if (this.credentials instanceof GuestCredentials) {
            uid = this.getAnonymousId();
        } else if (this.credentials instanceof ImpersonationCredentials && (bc = ((ImpersonationCredentials)this.credentials).getBaseCredentials()) instanceof SimpleCredentials) {
            uid = ((SimpleCredentials)bc).getUserID();
        }
        if (uid == null) {
            uid = this.getSharedLoginName();
        }
        return uid;
    }

    @Nullable
    private String getAnonymousId() {
        SecurityProvider sp = this.getSecurityProvider();
        if (sp == null) {
            return null;
        }
        ConfigurationParameters params = sp.getConfiguration(UserConfiguration.class).getParameters();
        return UserUtil.getAnonymousId(params);
    }

    @Nullable
    private Authentication getUserAuthentication(@Nullable String loginName) {
        SecurityProvider securityProvider = this.getSecurityProvider();
        Root root = this.getRoot();
        if (securityProvider != null && root != null) {
            UserConfiguration uc = securityProvider.getConfiguration(UserConfiguration.class);
            UserAuthenticationFactory factory = uc.getParameters().getConfigValue("userAuthenticationFactory", null, UserAuthenticationFactory.class);
            if (factory != null) {
                return factory.getAuthentication(uc, root, loginName);
            }
            log.error("No user authentication factory configured in user configuration.");
        }
        return null;
    }

    private boolean authenticate(@Nullable PreAuthenticatedLogin preAuthLogin, @NotNull Authentication authentication) throws LoginException {
        Credentials crds = preAuthLogin != null ? PreAuthenticatedLogin.PRE_AUTHENTICATED : this.credentials;
        try {
            return authentication.authenticate(crds);
        }
        catch (LoginException e) {
            this.getLoginModuleMonitor().loginFailed(e, crds);
            throw e;
        }
    }

    private AuthInfo createAuthInfo(@NotNull Set<? extends Principal> principals) {
        Credentials creds = this.credentials instanceof ImpersonationCredentials ? ((ImpersonationCredentials)this.credentials).getBaseCredentials() : this.credentials;
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        Object shared = this.sharedState.get("javax.security.auth.login.attributes");
        if (shared instanceof Map) {
            ((Map)shared).forEach((key, value) -> attributes.put(key.toString(), value));
        } else if (creds instanceof SimpleCredentials) {
            SimpleCredentials sc = (SimpleCredentials)creds;
            for (String attrName : sc.getAttributeNames()) {
                attributes.put(attrName, sc.getAttribute(attrName));
            }
        }
        return new AuthInfoImpl(this.userId, attributes, IterableUtils.chainedIterable(principals, this.subject.getPrincipals()));
    }

    static {
        SUPPORTED_CREDENTIALS.add(SimpleCredentials.class);
        SUPPORTED_CREDENTIALS.add(GuestCredentials.class);
        SUPPORTED_CREDENTIALS.add(ImpersonationCredentials.class);
    }
}

