/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.monitor;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.oak.security.authorization.monitor.AuthorizationMonitor;
import org.apache.jackrabbit.oak.stats.MeterStats;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.stats.StatsOptions;
import org.apache.jackrabbit.oak.stats.TimerStats;
import org.jetbrains.annotations.NotNull;

public class AuthorizationMonitorImpl
implements AuthorizationMonitor {
    private final MeterStats accessViolations;
    private final MeterStats permissionError;
    private final MeterStats permissionRefresh;
    private final TimerStats permissionAllLoaded;

    public AuthorizationMonitorImpl(@NotNull StatisticsProvider statisticsProvider) {
        this.accessViolations = statisticsProvider.getMeter("security.authorization.default.access.violation", StatsOptions.DEFAULT);
        this.permissionError = statisticsProvider.getMeter("security.authorization.default.permission.error", StatsOptions.DEFAULT);
        this.permissionRefresh = statisticsProvider.getMeter("security.authorization.default.permission.refresh", StatsOptions.DEFAULT);
        this.permissionAllLoaded = statisticsProvider.getTimer("security.authorization.default.permission.all_loaded", StatsOptions.METRICS_ONLY);
    }

    @Override
    @NotNull
    public Class<AuthorizationMonitor> getMonitorClass() {
        return AuthorizationMonitor.class;
    }

    @Override
    @NotNull
    public Map<Object, Object> getMonitorProperties() {
        return Collections.emptyMap();
    }

    @Override
    public void accessViolation() {
        this.accessViolations.mark();
    }

    @Override
    public void permissionError() {
        this.permissionError.mark();
    }

    @Override
    public void permissionRefresh() {
        this.permissionRefresh.mark();
    }

    @Override
    public void permissionAllLoaded(long timeTakenNanos) {
        this.permissionAllLoaded.update(timeTakenNanos, TimeUnit.NANOSECONDS);
    }
}

