/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.principal;

import java.util.Map;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.security.principal.PrincipalProviderImpl;
import org.apache.jackrabbit.oak.spi.security.ConfigurationBase;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityConfiguration;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalConfiguration;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalManagerImpl;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalProvider;
import org.apache.jackrabbit.oak.spi.security.user.UserConfiguration;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component(service={PrincipalConfiguration.class, SecurityConfiguration.class}, property={"oak.security.name=org.apache.jackrabbit.oak.security.principal.PrincipalConfigurationImpl"})
public class PrincipalConfigurationImpl
extends ConfigurationBase
implements PrincipalConfiguration {
    public PrincipalConfigurationImpl() {
    }

    public PrincipalConfigurationImpl(SecurityProvider securityProvider) {
        super(securityProvider, securityProvider.getParameters("org.apache.jackrabbit.oak.principal"));
    }

    @Activate
    private void activate(Map<String, Object> properties) {
        this.setParameters(ConfigurationParameters.of(properties));
    }

    @Override
    @NotNull
    public PrincipalManager getPrincipalManager(Root root, NamePathMapper namePathMapper) {
        PrincipalProvider principalProvider = this.getPrincipalProvider(root, namePathMapper);
        return new PrincipalManagerImpl(principalProvider);
    }

    @Override
    @NotNull
    public PrincipalProvider getPrincipalProvider(Root root, NamePathMapper namePathMapper) {
        UserConfiguration uc = this.getSecurityProvider().getConfiguration(UserConfiguration.class);
        PrincipalProvider principalProvider = uc.getUserPrincipalProvider(root, namePathMapper);
        if (principalProvider != null) {
            return principalProvider;
        }
        return new PrincipalProviderImpl(root, uc, namePathMapper);
    }

    @Override
    @NotNull
    public String getName() {
        return "org.apache.jackrabbit.oak.principal";
    }
}

