/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.mount;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.jackrabbit.oak.spi.mount.Mount;
import org.apache.jackrabbit.oak.spi.mount.MountInfo;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.mount.SimpleMountInfoProvider;

public final class Mounts {
    private static final MountInfoProvider DEFAULT_PROVIDER = new MountInfoProvider(){

        @Override
        public Mount getMountByPath(String path) {
            return DEFAULT_MOUNT;
        }

        @Override
        public Collection<Mount> getNonDefaultMounts() {
            return Collections.emptySet();
        }

        @Override
        public Mount getMountByName(String name) {
            return DEFAULT_MOUNT.getName().equals(name) ? DEFAULT_MOUNT : null;
        }

        @Override
        public boolean hasNonDefaultMounts() {
            return false;
        }

        @Override
        public Collection<Mount> getMountsPlacedUnder(String path) {
            return Collections.emptySet();
        }

        @Override
        public Collection<Mount> getMountsPlacedDirectlyUnder(String path) {
            return Collections.emptySet();
        }

        @Override
        public Mount getDefaultMount() {
            return DEFAULT_MOUNT;
        }
    };
    private static Mount DEFAULT_MOUNT = new DefaultMount();

    private Mounts() {
    }

    public static MountInfoProvider defaultMountInfoProvider() {
        return DEFAULT_PROVIDER;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private final List<Mount> mounts = new ArrayList<Mount>(1);

        private Builder() {
        }

        public Builder mount(String name, String ... paths) {
            this.mounts.add(new MountInfo(name, false, Collections.singletonList("/"), Arrays.asList(paths)));
            return this;
        }

        public Builder readOnlyMount(String name, String ... paths) {
            this.mounts.add(new MountInfo(name, true, Collections.singletonList("/"), Arrays.asList(paths)));
            return this;
        }

        public Builder mount(String name, boolean readOnly, List<String> pathsSupportingFragments, List<String> paths) {
            this.mounts.add(new MountInfo(name, readOnly, pathsSupportingFragments, paths));
            return this;
        }

        public MountInfoProvider build() {
            return new SimpleMountInfoProvider(this.mounts);
        }
    }

    static final class DefaultMount
    implements Mount {
        private final Collection<Mount> mounts;

        DefaultMount() {
            this(Collections.emptySet());
        }

        DefaultMount(Collection<Mount> mounts) {
            this.mounts = mounts;
        }

        @Override
        public String getName() {
            return "<default>";
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public boolean isDefault() {
            return true;
        }

        @Override
        public String getPathFragmentName() {
            return "";
        }

        @Override
        public boolean isSupportFragment(String path) {
            return false;
        }

        @Override
        public boolean isSupportFragmentUnder(String path) {
            return false;
        }

        @Override
        public boolean isMounted(String path) {
            for (Mount m : this.mounts) {
                if (!m.isMounted(path)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isUnder(String path) {
            for (Mount m : this.mounts) {
                if (!m.isMounted(path)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isDirectlyUnder(String path) {
            for (Mount m : this.mounts) {
                if (!m.isDirectlyUnder(path)) continue;
                return false;
            }
            return true;
        }
    }
}

