/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.query.fulltext;

import org.apache.jackrabbit.oak.spi.query.fulltext.FullTextExpression;
import org.apache.jackrabbit.oak.spi.query.fulltext.FullTextVisitor;

public class FullTextContains
extends FullTextExpression {
    private final String propertyName;
    private final String rawText;
    private final FullTextExpression base;

    public FullTextContains(String propertyName, String rawText, FullTextExpression base) {
        this.propertyName = propertyName;
        this.rawText = rawText;
        this.base = base;
    }

    @Override
    public int getPrecedence() {
        return this.base.getPrecedence();
    }

    @Override
    public boolean evaluate(String value) {
        return this.base.evaluate(value);
    }

    @Override
    FullTextExpression simplify() {
        FullTextExpression s = this.base.simplify();
        if (s == this.base) {
            return this;
        }
        return new FullTextContains(this.propertyName, this.rawText, s);
    }

    @Override
    public String toString() {
        return this.base.toString();
    }

    @Override
    public boolean accept(FullTextVisitor v) {
        return v.visit(this);
    }

    public FullTextExpression getBase() {
        return this.base;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getRawText() {
        return this.rawText;
    }

    @Override
    public boolean isNot() {
        return this.base.isNot();
    }
}

