/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.reference;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.ExecuteResult;
import org.owasp.esapi.Executor;
import org.owasp.esapi.Logger;
import org.owasp.esapi.codecs.Codec;
import org.owasp.esapi.codecs.UnixCodec;
import org.owasp.esapi.codecs.WindowsCodec;
import org.owasp.esapi.errors.ExecutorException;

public class DefaultExecutor
implements Executor {
    private static volatile Executor singletonInstance;
    private final Logger logger = ESAPI.getLogger("Executor");
    private Codec codec = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Executor getInstance() {
        if (singletonInstance != null) return singletonInstance;
        Class<DefaultExecutor> clazz = DefaultExecutor.class;
        synchronized (DefaultExecutor.class) {
            if (singletonInstance != null) return singletonInstance;
            singletonInstance = new DefaultExecutor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singletonInstance;
        }
    }

    private DefaultExecutor() {
        if (System.getProperty("os.name").indexOf("Windows") != -1) {
            this.logger.warning(Logger.SECURITY_SUCCESS, "Using WindowsCodec for Executor. If this is not running on Windows this could allow injection");
            this.codec = new WindowsCodec();
        } else {
            this.logger.warning(Logger.SECURITY_SUCCESS, "Using UnixCodec for Executor. If this is not running on Unix this could allow injection");
            this.codec = new UnixCodec();
        }
    }

    @Override
    public ExecuteResult executeSystemCommand(File executable, List params) throws ExecutorException {
        File workdir = ESAPI.securityConfiguration().getWorkingDirectory();
        boolean logParams = false;
        boolean redirectErrorStream = false;
        return this.executeSystemCommand(executable, params, workdir, this.codec, logParams, redirectErrorStream);
    }

    @Override
    public ExecuteResult executeSystemCommand(File executable, List params, File workdir, Codec codec, boolean logParams, boolean redirectErrorStream) throws ExecutorException {
        try {
            if (!executable.exists()) {
                throw new ExecutorException("Execution failure", "No such executable: " + executable);
            }
            if (!executable.isAbsolute()) {
                throw new ExecutorException("Execution failure", "Attempt to invoke an executable using a non-absolute path: " + executable);
            }
            if (!executable.getPath().equals(executable.getCanonicalPath())) {
                throw new ExecutorException("Execution failure", "Attempt to invoke an executable using a non-canonical path: " + executable);
            }
            List<String> approved = ESAPI.securityConfiguration().getAllowedExecutables();
            if (!approved.contains(executable.getPath())) {
                throw new ExecutorException("Execution failure", "Attempt to invoke executable that is not listed as an approved executable in ESAPI configuration: " + executable.getPath() + " not listed in " + approved);
            }
            for (int i = 0; i < params.size(); ++i) {
                String param = (String)params.get(i);
                params.set(i, ESAPI.encoder().encodeForOS(codec, param));
            }
            if (!workdir.exists()) {
                throw new ExecutorException("Execution failure", "No such working directory for running executable: " + workdir.getPath());
            }
            params.add(0, executable.getCanonicalPath());
            ProcessBuilder pb = new ProcessBuilder(params);
            Map<String, String> env = pb.environment();
            env.clear();
            pb.directory(workdir);
            pb.redirectErrorStream(redirectErrorStream);
            if (logParams) {
                this.logger.debug(Logger.SECURITY_SUCCESS, "Initiating executable: " + executable + " " + params + " in " + workdir);
            } else {
                this.logger.debug(Logger.SECURITY_SUCCESS, "Initiating executable: " + executable + " [sensitive parameters obscured] in " + workdir);
            }
            StringBuilder outputBuffer = new StringBuilder();
            StringBuilder errorsBuffer = new StringBuilder();
            Process process = pb.start();
            try {
                ReadThread errorReader;
                if (!redirectErrorStream) {
                    errorReader = new ReadThread(process.getErrorStream(), errorsBuffer);
                    errorReader.start();
                } else {
                    errorReader = null;
                }
                DefaultExecutor.readStream(process.getInputStream(), outputBuffer);
                if (errorReader != null) {
                    errorReader.join();
                    if (errorReader.exception != null) {
                        throw errorReader.exception;
                    }
                }
                process.waitFor();
            }
            catch (Throwable e) {
                process.destroy();
                throw new ExecutorException("Execution failure", "Exception thrown during execution of system command: " + e.getMessage(), e);
            }
            String output = outputBuffer.toString();
            String errors = errorsBuffer.toString();
            int exitValue = process.exitValue();
            if (errors != null && errors.length() > 0) {
                String logErrors = errors;
                int MAX_LEN = 256;
                if (logErrors.length() > 256) {
                    logErrors = logErrors.substring(0, 256) + "(truncated at " + 256 + " characters)";
                }
                this.logger.warning(Logger.SECURITY_SUCCESS, "Error during system command: " + logErrors);
            }
            if (exitValue != 0) {
                this.logger.warning(Logger.EVENT_FAILURE, "System command exited with non-zero status: " + exitValue);
            }
            this.logger.debug(Logger.SECURITY_SUCCESS, "System command complete");
            return new ExecuteResult(exitValue, output, errors);
        }
        catch (IOException e) {
            throw new ExecutorException("Execution failure", "Exception thrown during execution of system command: " + e.getMessage(), e);
        }
    }

    private static void readStream(InputStream is, StringBuilder sb) throws IOException {
        String line;
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        while ((line = br.readLine()) != null) {
            sb.append(line).append('\n');
        }
    }

    private static class ReadThread
    extends Thread {
        volatile IOException exception;
        private final InputStream stream;
        private final StringBuilder buffer;

        ReadThread(InputStream stream, StringBuilder buffer) {
            this.stream = stream;
            this.buffer = buffer;
        }

        @Override
        public void run() {
            try {
                DefaultExecutor.readStream(this.stream, this.buffer);
            }
            catch (IOException e) {
                this.exception = e;
            }
        }
    }
}

