/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.ScanResultConsumerBase;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public interface AsyncTableBuilder<C extends ScanResultConsumerBase> {
    public AsyncTableBuilder<C> setOperationTimeout(long var1, TimeUnit var3);

    public AsyncTableBuilder<C> setScanTimeout(long var1, TimeUnit var3);

    public AsyncTableBuilder<C> setRpcTimeout(long var1, TimeUnit var3);

    public AsyncTableBuilder<C> setReadRpcTimeout(long var1, TimeUnit var3);

    public AsyncTableBuilder<C> setWriteRpcTimeout(long var1, TimeUnit var3);

    public AsyncTableBuilder<C> setRetryPause(long var1, TimeUnit var3);

    @Deprecated
    default public AsyncTableBuilder<C> setRetryPauseForCQTBE(long pause, TimeUnit unit) {
        return this.setRetryPauseForServerOverloaded(pause, unit);
    }

    public AsyncTableBuilder<C> setRetryPauseForServerOverloaded(long var1, TimeUnit var3);

    default public AsyncTableBuilder<C> setMaxRetries(int maxRetries) {
        return this.setMaxAttempts(ConnectionUtils.retries2Attempts(maxRetries));
    }

    public AsyncTableBuilder<C> setMaxAttempts(int var1);

    public AsyncTableBuilder<C> setStartLogErrorsCnt(int var1);

    public AsyncTableBuilder<C> setRequestAttribute(String var1, byte[] var2);

    public AsyncTable<C> build();
}

