/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.HintingFilter;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.FilterProtos;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class TimestampsFilter
extends FilterBase
implements HintingFilter {
    private final boolean canHint;
    TreeSet<Long> timestamps;
    private static final int MAX_LOG_TIMESTAMPS = 5;
    long minTimestamp = Long.MAX_VALUE;

    public TimestampsFilter(List<Long> timestamps) {
        this(timestamps, false);
    }

    public TimestampsFilter(List<Long> timestamps, boolean canHint) {
        for (Long timestamp : timestamps) {
            Preconditions.checkArgument((timestamp >= 0L ? 1 : 0) != 0, (String)"must be positive %s", (Object)timestamp);
        }
        this.canHint = canHint;
        this.timestamps = new TreeSet<Long>(timestamps);
        this.init();
    }

    public List<Long> getTimestamps() {
        ArrayList<Long> list = new ArrayList<Long>(this.timestamps.size());
        list.addAll(this.timestamps);
        return list;
    }

    private void init() {
        if (this.timestamps.size() > 0) {
            this.minTimestamp = this.timestamps.first();
        }
    }

    public long getMin() {
        return this.minTimestamp;
    }

    @Override
    public boolean filterRowKey(Cell cell) throws IOException {
        return false;
    }

    @Override
    @Deprecated
    public Filter.ReturnCode filterKeyValue(Cell c) {
        return this.filterCell(c);
    }

    @Override
    public Filter.ReturnCode filterCell(Cell c) {
        if (this.timestamps.contains(c.getTimestamp())) {
            return Filter.ReturnCode.INCLUDE;
        }
        if (c.getTimestamp() < this.minTimestamp) {
            return Filter.ReturnCode.NEXT_COL;
        }
        return this.canHint ? Filter.ReturnCode.SEEK_NEXT_USING_HINT : Filter.ReturnCode.SKIP;
    }

    @Override
    public Cell getNextCellHint(Cell currentCell) throws IOException {
        if (!this.canHint) {
            return null;
        }
        Long nextTimestampObject = this.timestamps.lower(currentCell.getTimestamp());
        if (nextTimestampObject == null) {
            return PrivateCellUtil.createLastOnRowCol((Cell)currentCell);
        }
        long nextTimestamp = nextTimestampObject;
        return PrivateCellUtil.createFirstOnRowColTS((Cell)currentCell, (long)nextTimestamp);
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        ArrayList<Long> timestamps = new ArrayList<Long>(filterArguments.size());
        for (int i = 0; i < filterArguments.size(); ++i) {
            long timestamp = ParseFilter.convertByteArrayToLong(filterArguments.get(i));
            timestamps.add(timestamp);
        }
        return new TimestampsFilter(timestamps);
    }

    @Override
    public byte[] toByteArray() {
        FilterProtos.TimestampsFilter.Builder builder = FilterProtos.TimestampsFilter.newBuilder();
        builder.addAllTimestamps(this.timestamps);
        builder.setCanHint(this.canHint);
        return builder.build().toByteArray();
    }

    public static TimestampsFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        FilterProtos.TimestampsFilter proto;
        try {
            proto = FilterProtos.TimestampsFilter.parseFrom((byte[])pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException((Throwable)e);
        }
        return new TimestampsFilter(proto.getTimestampsList(), proto.hasCanHint() && proto.getCanHint());
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimestampsFilter)) {
            return false;
        }
        TimestampsFilter other = (TimestampsFilter)o;
        return this.getTimestamps().equals(other.getTimestamps());
    }

    @Override
    public String toString() {
        return this.toString(5);
    }

    protected String toString(int maxTimestamps) {
        StringBuilder tsList = new StringBuilder();
        int count = 0;
        for (Long ts : this.timestamps) {
            if (count >= maxTimestamps) break;
            tsList.append(ts.toString());
            if (++count >= this.timestamps.size() || count >= maxTimestamps) continue;
            tsList.append(", ");
        }
        return String.format("%s (%d/%d): [%s] canHint: [%b]", this.getClass().getSimpleName(), count, this.timestamps.size(), tsList.toString(), this.canHint);
    }

    public boolean equals(Object obj) {
        return obj instanceof Filter && this.areSerializedFieldsEqual((Filter)obj);
    }

    public int hashCode() {
        return Objects.hash(this.getTimestamps());
    }
}

