/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler.resource.strategies.scheduling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.storm.scheduler.ExecutorDetails;
import org.apache.storm.scheduler.WorkerSlot;
import org.apache.storm.scheduler.resource.RasNode;
import org.apache.storm.scheduler.resource.SchedulingResult;
import org.apache.storm.scheduler.resource.strategies.scheduling.BaseResourceAwareStrategy;
import org.apache.storm.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoundRobinResourceAwareStrategy
extends BaseResourceAwareStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(RoundRobinResourceAwareStrategy.class);

    public RoundRobinResourceAwareStrategy() {
        super(false, BaseResourceAwareStrategy.NodeSortType.COMMON);
    }

    private int getMaxNumberOfNodesRequested() {
        Map<String, Object> conf = this.topologyDetails.getConf();
        if (conf.get("topology.isolate.machines") == null) {
            return Integer.MAX_VALUE;
        }
        return ((Number)this.topologyDetails.getConf().get("topology.isolate.machines")).intValue();
    }

    private ArrayList<String> getTruncatedNodeList(Iterable<String> sortedNodesIterable) {
        int maxNodes = this.getMaxNumberOfNodesRequested();
        ArrayList<String> ret = new ArrayList<String>();
        sortedNodesIterable.forEach(node -> {
            RasNode rasNode;
            Collection<String> runningTopos;
            if (ret.size() < maxNodes && ((runningTopos = (rasNode = this.nodes.getNodeById((String)node)).getRunningTopologies()).isEmpty() || runningTopos.size() == 1 && runningTopos.contains(this.topologyDetails.getId()))) {
                ret.add((String)node);
            }
        });
        return ret;
    }

    @Override
    protected SchedulingResult scheduleExecutorsOnNodes(List<ExecutorDetails> orderedExecutors, Iterable<String> sortedNodesIterable) {
        String comp;
        int execIndex;
        long startTimeMilli = Time.currentTimeMillis();
        int maxExecCnt = this.searcherState.getExecSize();
        int nodeSortCnt = 1;
        Iterator<String> sortedNodesIter = null;
        ArrayList<String> sortedNodes = this.getTruncatedNodeList(sortedNodesIterable);
        LOG.debug("scheduleExecutorsOnNodes: will assign {} executors for topo {}", (Object)maxExecCnt, (Object)this.topoName);
        this.searcherState.setSortedExecs(orderedExecutors);
        int loopCnt = 0;
        while (true) {
            block12: {
                LOG.debug("scheduleExecutorsOnNodes: loopCnt={}, execIndex={}, topo={}, nodeSortCnt={}", new Object[]{loopCnt, this.searcherState.getExecIndex(), this.topoName, nodeSortCnt});
                if (this.searcherState.areSearchLimitsExceeded()) {
                    LOG.warn("Limits exceeded, loopCnt={}, topo={}, nodeSortCnt={}", new Object[]{loopCnt, this.topoName, nodeSortCnt});
                    return this.searcherState.createSchedulingResult(false, this.getClass().getSimpleName());
                }
                if (Thread.currentThread().isInterrupted()) {
                    return this.searcherState.createSchedulingResult(false, this.getClass().getSimpleName());
                }
                execIndex = this.searcherState.getExecIndex();
                ExecutorDetails exec = this.searcherState.currentExec();
                if (this.searcherState.getBoundAckers().contains(exec)) {
                    if (this.searcherState.areAllExecsScheduled()) {
                        LOG.info("scheduleExecutorsOnNodes: Done at loopCnt={} in {}ms, state.elapsedtime={}, topo={}, nodeSortCnt={}", new Object[]{loopCnt, Time.currentTimeMillis() - startTimeMilli, Time.currentTimeMillis() - this.searcherState.getStartTimeMillis(), this.topoName, nodeSortCnt});
                        return this.searcherState.createSchedulingResult(true, this.getClass().getSimpleName());
                    }
                    this.searcherState = this.searcherState.nextExecutor();
                } else {
                    comp = (String)this.execToComp.get(exec);
                    if (sortedNodesIter == null || this.searcherState.isExecCompDifferentFromPrior() || !sortedNodesIter.hasNext()) {
                        sortedNodesIter = sortedNodes.iterator();
                        ++nodeSortCnt;
                    }
                    while (sortedNodesIter.hasNext()) {
                        String nodeId = sortedNodesIter.next();
                        RasNode node = this.nodes.getNodeById(nodeId);
                        if (!node.couldEverFit(exec, this.topologyDetails)) continue;
                        for (WorkerSlot workerSlot : node.getSlotsAvailableToScheduleOn()) {
                            if (!this.isExecAssignmentToWorkerValid(exec, workerSlot)) {
                                LOG.trace("Failed to assign exec={}, comp={}, topo={} to worker={} on node=({}, availCpu={}, availMem={}).", new Object[]{exec, comp, this.topoName, workerSlot, node.getId(), node.getAvailableCpuResources(), node.getAvailableMemoryResources()});
                                continue;
                            }
                            this.searcherState.incStatesSearched();
                            this.searcherState.assignCurrentExecutor(this.execToComp, node, workerSlot);
                            int numBoundAckerAssigned = this.assignBoundAckersForNewWorkerSlot(exec, node, workerSlot);
                            if (numBoundAckerAssigned > 0) {
                                this.searcherState.getExecsWithBoundAckers().add(exec);
                            }
                            if (this.searcherState.areAllExecsScheduled()) {
                                LOG.info("scheduleExecutorsOnNodes: Done at loopCnt={} in {}ms, state.elapsedtime={}, topo={}, nodeSortCnt={}", new Object[]{loopCnt, Time.currentTimeMillis() - startTimeMilli, Time.currentTimeMillis() - this.searcherState.getStartTimeMillis(), this.topoName, nodeSortCnt});
                                return this.searcherState.createSchedulingResult(true, this.getClass().getSimpleName());
                            }
                            this.searcherState = this.searcherState.nextExecutor();
                            LOG.debug("scheduleExecutorsOnNodes: Assigned execId={}, comp={} to node={}/cpu={}/mem={}, worker-port={} at loopCnt={}, topo={}, nodeSortCnt={}", new Object[]{execIndex, comp, nodeId, node.getAvailableCpuResources(), node.getAvailableMemoryResources(), workerSlot.getPort(), loopCnt, this.topoName, nodeSortCnt});
                            break block12;
                        }
                    }
                    break;
                }
            }
            ++loopCnt;
        }
        LOG.debug("scheduleExecutorsOnNodes: Failed to schedule execId={}, comp={} at loopCnt={}, topo={}, nodeSortCnt={}", new Object[]{execIndex, comp, loopCnt, this.topoName, nodeSortCnt});
        boolean success = this.searcherState.areAllExecsScheduled();
        LOG.info("scheduleExecutorsOnNodes: Scheduled={} in {} milliseconds, state.elapsedtime={}, topo={}, nodeSortCnt={}", new Object[]{success, Time.currentTimeMillis() - startTimeMilli, Time.currentTimeMillis() - this.searcherState.getStartTimeMillis(), this.topoName, nodeSortCnt});
        return this.searcherState.createSchedulingResult(success, this.getClass().getSimpleName());
    }
}

