/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.messaging.netty;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.apache.storm.messaging.IConnection;
import org.apache.storm.messaging.IConnectionCallback;
import org.apache.storm.messaging.IContext;
import org.apache.storm.messaging.netty.Client;
import org.apache.storm.messaging.netty.NettyRenameThreadFactory;
import org.apache.storm.messaging.netty.Server;
import org.apache.storm.metrics2.StormMetricRegistry;
import org.apache.storm.shade.io.netty.channel.EventLoopGroup;
import org.apache.storm.shade.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.storm.shade.io.netty.util.HashedWheelTimer;
import org.apache.storm.utils.ObjectReader;

public class Context
implements IContext {
    private Map<String, Object> topoConf;
    private List<Server> serverConnections;
    private EventLoopGroup workerEventLoopGroup;
    private HashedWheelTimer clientScheduleService;
    private StormMetricRegistry metricRegistry = null;

    @Override
    public void prepare(Map<String, Object> topoConf) {
        this.prepare(topoConf, null);
    }

    @Override
    public void prepare(Map<String, Object> topoConf, StormMetricRegistry metricRegistry) {
        this.topoConf = topoConf;
        this.serverConnections = new ArrayList<Server>();
        int maxWorkers = ObjectReader.getInt(topoConf.get("storm.messaging.netty.client_worker_threads"));
        NettyRenameThreadFactory workerFactory = new NettyRenameThreadFactory("client-worker");
        this.workerEventLoopGroup = new NioEventLoopGroup(maxWorkers > 0 ? maxWorkers : 0, (ThreadFactory)workerFactory);
        this.clientScheduleService = new HashedWheelTimer((ThreadFactory)new NettyRenameThreadFactory("client-schedule-service"));
        this.metricRegistry = metricRegistry;
    }

    @Override
    public synchronized IConnection bind(String stormId, int port, IConnectionCallback cb, Supplier<Object> newConnectionResponse) {
        Server server = new Server(this.topoConf, port, cb, newConnectionResponse);
        this.serverConnections.add(server);
        return server;
    }

    @Override
    public IConnection connect(String stormId, String host, int port, AtomicBoolean[] remoteBpStatus) {
        return new Client(this.topoConf, remoteBpStatus, this.workerEventLoopGroup, this.clientScheduleService, host, port, this.metricRegistry);
    }

    @Override
    public synchronized void term() {
        this.clientScheduleService.stop();
        for (Server conn : this.serverConnections) {
            conn.close();
        }
        this.serverConnections = null;
        this.workerEventLoopGroup.shutdownGracefully().awaitUninterruptibly();
    }
}

