/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly;

import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.nio.channels.Channel;
import java.util.Random;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.PortRange;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.ProcessorSelector;
import org.glassfish.grizzly.SocketBinder;
import org.glassfish.grizzly.nio.NIOTransport;

public abstract class AbstractBindingHandler
implements SocketBinder {
    protected static final Random RANDOM = new Random();
    protected final NIOTransport transport;
    protected Processor processor;
    protected ProcessorSelector processorSelector;

    public AbstractBindingHandler(NIOTransport transport) {
        this.transport = transport;
        this.processor = transport.getProcessor();
        this.processorSelector = transport.getProcessorSelector();
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public void setProcessor(Processor processor) {
        this.processor = processor;
    }

    public ProcessorSelector getProcessorSelector() {
        return this.processorSelector;
    }

    public void setProcessorSelector(ProcessorSelector processorSelector) {
        this.processorSelector = processorSelector;
    }

    @Override
    public Connection<?> bind(int port) throws IOException {
        return this.bind(new InetSocketAddress(port));
    }

    @Override
    public Connection<?> bind(String host, int port) throws IOException {
        return this.bind(new InetSocketAddress(host, port));
    }

    @Override
    public Connection<?> bind(String host, int port, int backlog) throws IOException {
        return this.bind(new InetSocketAddress(host, port), backlog);
    }

    @Override
    public Connection<?> bind(String host, PortRange portRange, int backlog) throws IOException {
        return this.bind(host, portRange, true, backlog);
    }

    @Override
    public Connection<?> bind(String host, PortRange portRange, boolean randomStartPort, int backlog) throws IOException {
        int lower = portRange.getLower();
        int range = portRange.getUpper() - lower + 1;
        int initialOffset = randomStartPort ? RANDOM.nextInt(range) : 0;
        int offset = initialOffset;
        while (true) {
            int port = lower + offset;
            try {
                return this.bind(host, port, backlog);
            }
            catch (IOException iOException) {
                if ((offset = (offset + 1) % range) != initialOffset) continue;
                throw new BindException(String.format("Couldn't bind to any port in the range `%s`.", portRange.toString()));
            }
            break;
        }
    }

    @Override
    public final void unbindAll() {
        throw new UnsupportedOperationException();
    }

    protected <T> T getSystemInheritedChannel(Class<?> channelType) throws IOException {
        Channel inheritedChannel = System.inheritedChannel();
        if (inheritedChannel == null) {
            throw new IOException("Inherited channel is not set");
        }
        if (!channelType.isInstance(inheritedChannel)) {
            throw new IOException("Inherited channel is not " + channelType.getName() + ", but " + inheritedChannel.getClass().getName());
        }
        return (T)inheritedChannel;
    }

    public static abstract class Builder<E extends Builder> {
        protected Processor processor;
        protected ProcessorSelector processorSelector;

        public E processor(Processor processor) {
            this.processor = processor;
            return (E)this;
        }

        public E processorSelector(ProcessorSelector processorSelector) {
            this.processorSelector = processorSelector;
            return (E)this;
        }

        public AbstractBindingHandler build() {
            AbstractBindingHandler bindingHandler = this.create();
            if (this.processor != null) {
                bindingHandler.setProcessor(this.processor);
            }
            if (this.processorSelector != null) {
                bindingHandler.setProcessorSelector(this.processorSelector);
            }
            return bindingHandler;
        }

        protected abstract AbstractBindingHandler create();
    }
}

