/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jetty;

import io.dropwizard.jetty.ZipExceptionHandlingRequestWrapper;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.util.Callback;

class ZipExceptionHandlingGzipHandler
extends GzipHandler {
    ZipExceptionHandlingGzipHandler() {
    }

    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        ZipExceptionHandlingRequestWrapper requestWrapper = new ZipExceptionHandlingRequestWrapper(request, response);
        boolean handled = super.handle((Request)requestWrapper, response, callback);
        if (handled && response.isCommitted()) {
            return true;
        }
        if (this.handleGzipExceptionIfNecessary(requestWrapper, response, callback)) {
            return true;
        }
        return handled;
    }

    private boolean handleGzipExceptionIfNecessary(ZipExceptionHandlingRequestWrapper request, Response response, Callback callback) {
        if (request.getGzipException() == null) {
            return false;
        }
        Throwable throwable = request.getGzipException();
        Response.writeError((Request)request, (Response)response, (Callback)callback, (int)400, (String)throwable.getMessage(), (Throwable)throwable);
        return true;
    }
}

