/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.storm.generated.Nimbus;
import org.apache.storm.generated.NimbusSummary;
import org.apache.storm.security.auth.ReqContext;
import org.apache.storm.security.auth.ThriftClient;
import org.apache.storm.security.auth.ThriftConnectionType;
import org.apache.storm.thrift.transport.TTransportException;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.NimbusLeaderNotFoundException;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NimbusClient
extends ThriftClient {
    private static final Logger LOG = LoggerFactory.getLogger(NimbusClient.class);
    private static volatile Nimbus.Iface _localOverrideClient = null;
    private static String oldLeader = "";
    public final boolean isLocal;
    private final Nimbus.Iface client;

    @Deprecated
    public NimbusClient(Map<String, Object> conf, String host, int port, Integer timeout) throws TTransportException {
        this(conf, host, port, timeout, null);
    }

    @Deprecated
    public NimbusClient(Map<String, Object> conf, String host, Integer port, Integer timeout, String asUser) throws TTransportException {
        this(conf, host, port, timeout, asUser, false);
    }

    @Deprecated
    public NimbusClient(Map<String, Object> conf, String host, Integer port, Integer timeout, String asUser, boolean useTls) throws TTransportException {
        super(conf, useTls ? ThriftConnectionType.NIMBUS_TLS : ThriftConnectionType.NIMBUS, host, port, timeout, asUser);
        this.client = new Nimbus.Client(this.protocol);
        this.isLocal = false;
    }

    @Deprecated
    public NimbusClient(Map<String, Object> conf, String host) throws TTransportException {
        this(conf, host, null, null, null);
    }

    private NimbusClient(Nimbus.Iface client) {
        super(new HashMap<String, Object>(), ThriftConnectionType.LOCAL_FAKE, "localhost", null, null, null);
        this.client = client;
        this.isLocal = true;
    }

    public static boolean isLocalOverride() {
        return _localOverrideClient != null;
    }

    public static void withConfiguredClient(WithNimbus cb) throws Exception {
        NimbusClient.withConfiguredClient(cb, ConfigUtils.readStormConfig());
    }

    public static void withConfiguredClient(WithNimbus cb, Map<String, Object> conf) throws Exception {
        try (NimbusClient client = Builder.withConf(conf).build();){
            cb.run(client.getClient());
        }
    }

    @Deprecated
    public static NimbusClient getConfiguredClient(Map<String, Object> conf) {
        return NimbusClient.getConfiguredClientAs(conf, null);
    }

    @Deprecated
    public static NimbusClient getConfiguredClient(Map<String, Object> conf, Integer timeout) {
        return NimbusClient.getConfiguredClientAs(conf, null, timeout);
    }

    private static synchronized boolean shouldLogLeader(String leader) {
        assert (leader != null);
        if (LOG.isDebugEnabled()) {
            return true;
        }
        if (oldLeader.equals(leader)) {
            return false;
        }
        oldLeader = leader;
        return true;
    }

    @Deprecated
    public static NimbusClient getConfiguredClientAs(Map<String, Object> conf, String asUser) {
        return NimbusClient.getConfiguredClientAs(conf, asUser, null);
    }

    @Deprecated
    public static NimbusClient getConfiguredClientAs(Map<String, Object> conf, String asUser, Integer timeout) {
        return NimbusClient.createNimbusClient(conf, asUser, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NimbusClient createNimbusClient(Map<String, Object> conf, String asUser, Integer timeout) {
        Nimbus.Iface override = _localOverrideClient;
        if (override != null) {
            return new NimbusClient(override);
        }
        Map<String, Object> fullConf = Utils.readStormConfig();
        fullConf.putAll(Utils.readCommandLineOpts());
        fullConf.putAll(conf);
        conf = fullConf;
        if (conf.containsKey("storm.doAsUser")) {
            if (asUser != null && !asUser.isEmpty()) {
                LOG.warn("You have specified a doAsUser as param {} and a doAsParam as config, config will take precedence.", (Object)asUser, conf.get("storm.doAsUser"));
            }
            asUser = (String)conf.get("storm.doAsUser");
        }
        if (asUser == null || asUser.isEmpty()) {
            ReqContext context = ReqContext.context();
            Principal principal = context.principal();
            asUser = principal == null ? null : principal.getName();
            LOG.debug("Will impersonate {} based off of request context.", (Object)asUser);
        }
        List seeds = (List)conf.get("nimbus.seeds");
        boolean useTls = ObjectReader.getBoolean(conf.get("nimbus.thrift.client.use.tls"), false);
        if (useTls && null == ObjectReader.getString(conf.get("nimbus.thrift.tls.transport"))) {
            throw new RuntimeException("nimbus.thrift.tls.transport must be set to use a transport plugin that supports tls");
        }
        int port = Integer.parseInt(conf.get("nimbus.thrift.port").toString());
        int tlsPort = Integer.parseInt(conf.get("nimbus.thrift.tls.port").toString());
        int configuredPortToUse = useTls ? tlsPort : port;
        for (String host : seeds) {
            ThriftClient client = null;
            try {
                client = new NimbusClient(conf, host, configuredPortToUse, timeout, asUser, useTls);
                NimbusSummary nimbusSummary = ((NimbusClient)client).getClient().getLeader();
                if (nimbusSummary != null) {
                    int nimbusPortFromSummary;
                    String leaderNimbus = nimbusSummary.get_host() + ":" + nimbusSummary.get_port() + ":" + nimbusSummary.get_tlsPort();
                    if (NimbusClient.shouldLogLeader(leaderNimbus)) {
                        LOG.info("Found leader nimbus : {}", (Object)leaderNimbus);
                    }
                    int n = nimbusPortFromSummary = useTls ? nimbusSummary.get_tlsPort() : nimbusSummary.get_port();
                    if (nimbusSummary.get_host().equals(host) && nimbusPortFromSummary == port) {
                        ThriftClient ret = client;
                        client = null;
                        ThriftClient thriftClient = ret;
                        return thriftClient;
                    }
                    NimbusClient ret = new NimbusClient(conf, nimbusSummary.get_host(), nimbusPortFromSummary, timeout, asUser, useTls);
                    return ret;
                }
            }
            catch (Exception e) {
                LOG.warn("Ignoring exception while trying to get leader nimbus info from " + host + ". will retry with a different seed host.", (Throwable)e);
                continue;
            }
            finally {
                if (client == null) continue;
                client.close();
                continue;
            }
            throw new NimbusLeaderNotFoundException("Could not find a nimbus leader, please try again after some time.");
        }
        throw new NimbusLeaderNotFoundException("Could not find leader nimbus from seed hosts " + String.valueOf(seeds) + ". Did you specify a valid list of nimbus hosts for config nimbus.seeds?");
    }

    public Nimbus.Iface getClient() {
        return this.client;
    }

    public static interface WithNimbus {
        public void run(Nimbus.Iface var1) throws Exception;
    }

    public static class Builder {
        private Map<String, Object> conf;
        private String asUser;
        private Integer timeout;
        private boolean forDaemon = false;

        private Builder(Map<String, Object> conf) {
            this.conf = conf;
        }

        public static Builder withConf(Map<String, Object> conf) {
            return new Builder(conf);
        }

        public Builder asUser(String asUser) {
            this.asUser = asUser;
            return this;
        }

        public Builder withTimeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder forDaemon() {
            this.forDaemon = true;
            return this;
        }

        public NimbusClient buildWithNimbusHostPort(String host, Integer port) throws TTransportException {
            return new NimbusClient(this.conf, host, port, this.timeout, this.asUser, false);
        }

        public NimbusClient build() {
            return NimbusClient.createNimbusClient(this.conf, this.asUser, this.timeout);
        }
    }

    public static final class LocalOverride
    implements AutoCloseable {
        public LocalOverride(Nimbus.Iface client) {
            _localOverrideClient = client;
        }

        @Override
        public void close() throws Exception {
            _localOverrideClient = null;
        }
    }
}

