/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.com.google.common.collect;

import com.google.common.base.Nullable;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.collect.ImmutableCollection;
import com.google.gxp.com.google.common.collect.ImmutableList;
import com.google.gxp.com.google.common.collect.ImmutableMap;
import com.google.gxp.com.google.common.collect.ImmutableMultiset;
import com.google.gxp.com.google.common.collect.ImmutableSet;
import com.google.gxp.com.google.common.collect.ListMultimap;
import com.google.gxp.com.google.common.collect.Lists;
import com.google.gxp.com.google.common.collect.Maps;
import com.google.gxp.com.google.common.collect.Multimap;
import com.google.gxp.com.google.common.collect.Serialization;
import com.google.gxp.com.google.common.collect.StandardMultimap;
import com.google.gxp.com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImmutableMultimap<K, V>
implements ListMultimap<K, V>,
Serializable {
    private static ImmutableMultimap<Object, Object> EMPTY_MULTIMAP = new EmptyMultimap();
    private final transient ImmutableMap<K, ImmutableList<V>> map;
    private final transient int size;
    private transient ImmutableCollection<Map.Entry<K, V>> entries;
    private transient ImmutableMultiset<K> keys;
    private transient ImmutableCollection<V> values;
    private static final long serialVersionUID = 0L;

    public static <K, V> ImmutableMultimap<K, V> empty() {
        return EMPTY_MULTIMAP;
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public static <K, V> ImmutableMultimap<K, V> copyOf(Multimap<? extends K, ? extends V> multimap) {
        if (multimap.isEmpty()) {
            return ImmutableMultimap.empty();
        }
        if (multimap instanceof ImmutableMultimap) {
            ImmutableMultimap kvMultimap = (ImmutableMultimap)multimap;
            return kvMultimap;
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        int size = 0;
        for (Map.Entry<K, Collection<V>> entry : multimap.asMap().entrySet()) {
            ImmutableList list = ImmutableList.copyOf((Iterable)entry.getValue());
            if (list.isEmpty()) continue;
            builder.put(entry.getKey(), list);
            size += list.size();
        }
        return new ImmutableMultimap(builder.build(), size);
    }

    private ImmutableMultimap(ImmutableMap<K, ImmutableList<V>> map, int size) {
        this.map = map;
        this.size = size;
    }

    @Override
    public List<V> removeAll(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<V> replaceValues(K key, Iterable<? extends V> values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean putAll(K key, Iterable<? extends V> values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean putAll(Multimap<? extends K, ? extends V> multimap) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsEntry(@Nullable Object key, @Nullable Object value) {
        Collection valueList = this.map.get(key);
        return valueList != null && valueList.contains(value);
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        for (ImmutableList valueList : this.map.values()) {
            if (!valueList.contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj instanceof Multimap) {
            Multimap that = (Multimap)obj;
            return this.map.equals(that.asMap());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public ImmutableList<V> get(@Nullable K key) {
        ImmutableList<V> list = this.map.get(key);
        return list == null ? ImmutableList.of() : list;
    }

    @Override
    public ImmutableSet<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public ImmutableMap<K, Collection<V>> asMap() {
        return this.map;
    }

    @Override
    public ImmutableCollection<Map.Entry<K, V>> entries() {
        ImmutableCollection<Map.Entry<K, V>> result = this.entries;
        return result == null ? (this.entries = new Entries(this)) : result;
    }

    @Override
    public ImmutableMultiset<K> keys() {
        ImmutableMultiset<K> result = this.keys;
        return result == null ? (this.keys = new ImmutableMultiset(new CountMap(this), this.size)) : result;
    }

    @Override
    public ImmutableCollection<V> values() {
        ImmutableCollection<V> v = this.values;
        return v == null ? (this.values = new Values(this)) : v;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        Serialization.writeMultimap(this, stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException, NoSuchFieldException {
        stream.defaultReadObject();
        int keyCount = stream.readInt();
        if (keyCount < 0) {
            throw new InvalidObjectException("Invalid key count " + keyCount);
        }
        ImmutableMap.Builder<Object, ImmutableList<Object>> builder = ImmutableMap.builder();
        int tmpSize = 0;
        for (int i = 0; i < keyCount; ++i) {
            Object key = stream.readObject();
            int valueCount = stream.readInt();
            if (valueCount <= 0) {
                throw new InvalidObjectException("Invalid value count " + valueCount);
            }
            Object[] values = new Object[valueCount];
            for (int j = 0; j < valueCount; ++j) {
                Object value;
                values[j] = value = stream.readObject();
                tmpSize += valueCount;
            }
            builder.put(key, ImmutableList.of(values));
        }
        Serialization.setFinalField(ImmutableMultimap.class, this, "map", builder.build());
        Serialization.setFinalField(ImmutableMultimap.class, this, "size", tmpSize);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Values<V>
    extends ImmutableCollection<V> {
        final Multimap<?, V> multimap;
        private static final long serialVersionUID = 0L;

        Values(Multimap<?, V> multimap) {
            this.multimap = multimap;
        }

        @Override
        public Iterator<V> iterator() {
            final Iterator<Map.Entry<?, V>> entryIterator = this.multimap.entries().iterator();
            return new UnmodifiableIterator<V>(){

                @Override
                public boolean hasNext() {
                    return entryIterator.hasNext();
                }

                @Override
                public V next() {
                    return ((Map.Entry)entryIterator.next()).getValue();
                }
            };
        }

        @Override
        public int size() {
            return this.multimap.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CountMap<K, V>
    extends ImmutableMap<K, Integer> {
        final ImmutableMultimap<K, V> multimap;
        transient ImmutableSet<Map.Entry<K, Integer>> entrySet;
        private static final long serialVersionUID = 0L;

        CountMap(ImmutableMultimap<K, V> multimap) {
            this.multimap = multimap;
        }

        @Override
        public boolean containsKey(Object key) {
            return this.multimap.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer get(Object key) {
            Collection valueList = (Collection)((ImmutableMultimap)this.multimap).map.get(key);
            return valueList == null ? 0 : valueList.size();
        }

        @Override
        public ImmutableSet<K> keySet() {
            return this.multimap.keySet();
        }

        @Override
        public ImmutableCollection<Integer> values() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            return this.multimap.isEmpty();
        }

        @Override
        public int size() {
            return ((ImmutableMultimap)this.multimap).map.size();
        }

        @Override
        public ImmutableSet<Map.Entry<K, Integer>> entrySet() {
            ImmutableSet<Map.Entry<K, Integer>> result = this.entrySet;
            return result == null ? (this.entrySet = new EntrySet<K, V>(this.multimap)) : result;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class EntrySet<K, V>
        extends ImmutableSet<Map.Entry<K, Integer>> {
            final ImmutableMultimap<K, V> multimap;
            private static final long serialVersionUID = 0L;

            EntrySet(ImmutableMultimap<K, V> multimap) {
                this.multimap = multimap;
            }

            @Override
            public Iterator<Map.Entry<K, Integer>> iterator() {
                final Iterator mapIterator = ((ImmutableMultimap)this.multimap).map.entrySet().iterator();
                return new UnmodifiableIterator<Map.Entry<K, Integer>>(){

                    @Override
                    public boolean hasNext() {
                        return mapIterator.hasNext();
                    }

                    @Override
                    public Map.Entry<K, Integer> next() {
                        Map.Entry entry = (Map.Entry)mapIterator.next();
                        return Maps.immutableEntry(entry.getKey(), ((ImmutableList)entry.getValue()).size());
                    }
                };
            }

            @Override
            public int size() {
                return ((ImmutableMultimap)this.multimap).map.size();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entries<K, V>
    extends ImmutableCollection<Map.Entry<K, V>> {
        final ImmutableMultimap<K, V> multimap;
        private static final long serialVersionUID = 0L;

        Entries(ImmutableMultimap<K, V> multimap) {
            this.multimap = multimap;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            final Iterator mapIterator = ((ImmutableMultimap)this.multimap).map.entrySet().iterator();
            return new UnmodifiableIterator<Map.Entry<K, V>>(){
                Map.Entry<K, ImmutableList<V>> mapEntry;
                int index;

                @Override
                public boolean hasNext() {
                    return this.mapEntry != null && this.index < this.mapEntry.getValue().size() || mapIterator.hasNext();
                }

                @Override
                public Map.Entry<K, V> next() {
                    if (this.mapEntry == null || this.index >= this.mapEntry.getValue().size()) {
                        this.mapEntry = (Map.Entry)mapIterator.next();
                        this.index = 0;
                    }
                    Object value = this.mapEntry.getValue().get(this.index);
                    ++this.index;
                    return Maps.immutableEntry(this.mapEntry.getKey(), value);
                }
            };
        }

        @Override
        public int size() {
            return this.multimap.size();
        }

        @Override
        public boolean contains(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                return this.multimap.containsEntry(entry.getKey(), entry.getValue());
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder<K, V> {
        private final Multimap<K, V> builderMultimap = new BuilderMultimap();

        public Builder<K, V> put(K key, V value) {
            this.builderMultimap.put(Preconditions.checkNotNull(key), Preconditions.checkNotNull(value));
            return this;
        }

        public Builder<K, V> putAll(K key, Iterable<? extends V> values) {
            Collection<V> valueList = this.builderMultimap.get(Preconditions.checkNotNull(key));
            for (V value : values) {
                valueList.add(Preconditions.checkNotNull(value));
            }
            return this;
        }

        public Builder<K, V> putAll(K key, V ... values) {
            Collection<V> valueList = this.builderMultimap.get(Preconditions.checkNotNull(key));
            for (V value : values) {
                valueList.add(Preconditions.checkNotNull(value));
            }
            return this;
        }

        public ImmutableMultimap<K, V> build() {
            return ImmutableMultimap.copyOf(this.builderMultimap);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BuilderMultimap<K, V>
    extends StandardMultimap<K, V> {
        private static final long serialVersionUID = 0L;

        BuilderMultimap() {
            super(new LinkedHashMap());
        }

        @Override
        Collection<V> createCollection() {
            return Lists.newArrayList();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptyMultimap
    extends ImmutableMultimap<Object, Object> {
        private static final long serialVersionUID = 0L;

        EmptyMultimap() {
            super(ImmutableMap.of(), 0);
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        Object readResolve() {
            return EMPTY_MULTIMAP;
        }
    }
}

