/*
 * Decompiled with CFR 0.152.
 */
package com.google.transconsole.common.messages;

import com.google.gxp.com.google.common.base.CharEscaper;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.transconsole.common.messages.Message;
import com.google.transconsole.common.messages.MessageBundle;
import java.io.IOException;

public class PropertiesBundleWriter {
    private final MessageBundle bundle;
    private static final CharEscaper MESSAGE_ESCAPER = new CharEscaper(){

        @Override
        public char[] escape(char c) {
            switch (c) {
                case '!': 
                case '#': 
                case ':': 
                case '=': 
                case '\\': {
                    char[] x = new char[]{'\\', c};
                    return x;
                }
            }
            if (c < ' ' || '~' < c) {
                char[] r = new char[6];
                r[5] = HEX_DIGITS[c & 0xF];
                c = (char)(c >>> 4);
                r[4] = HEX_DIGITS[c & 0xF];
                c = (char)(c >>> 4);
                r[3] = HEX_DIGITS[c & 0xF];
                c = (char)(c >>> 4);
                r[2] = HEX_DIGITS[c & 0xF];
                r[1] = 117;
                r[0] = 92;
                return r;
            }
            return null;
        }
    };
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public PropertiesBundleWriter(MessageBundle bundle) {
        this.bundle = Preconditions.checkNotNull(bundle);
    }

    public void write(Appendable out) throws IOException {
        out.append("# Message Translations File for Java\n");
        out.append("# project=");
        out.append(this.bundle.getProjectId());
        out.append('\n');
        out.append("# language=");
        out.append(this.bundle.getLanguage());
        out.append("\n\n");
        for (Message m : this.bundle.getMessages()) {
            out.append(m.getId());
            out.append(" = ");
            if (m.getOriginal().charAt(0) == ' ') {
                out.append('\\');
            }
            MESSAGE_ESCAPER.escape(out).append(m.getOriginal());
            out.append('\n');
        }
    }
}

